#include <stdio.h>
#include <ctype.h>

char *programs_name;

/* entry is used with pairs and rounds so the information
   exists twice except for the "stationary" part! */

typedef struct entry
 {
  int table, versus, ns, board_set, stationary;
 }
entry;

entry **chart;

int main(int iargc, char *argv[], char **envp)
 {
  int b, c, i, j, p, q, r, t, h, v, n, ok, oldp, newp, oldv,
      pairs, rounds, tables, page, pages, row, column,
      friend, foe, boards, files, table, oldb, blanks;
  double badness;
  char *s, *name, line[132], buffer[132];
  FILE *fp;
  char *direction, *header, *tailer;
  setbuf(stdout, NULL);
  for(programs_name=s=argv[0]; (*s);) if((*s++)=='/') programs_name=s;
  pairs=14; rounds=pairs-1; name=NULL; boards=0;
  tables=(pairs+1)/2;
  for(i=1; i<iargc; i++)
   {
    if((*argv[i])!='-') name=argv[i];
    if(strncmp(argv[i], "-p", 2)==0)
     {sscanf(argv[i]+2, "%d", &pairs); rounds=pairs-1; tables=(pairs+1)/2;}
    if(strncmp(argv[i], "-r", 2)==0) sscanf(argv[i]+2, "%d", &rounds);
    if(strncmp(argv[i], "-b", 2)==0) sscanf(argv[i]+2, "%d", &boards);
   }
  printf("%s: %d pairs with %d rounds %d tables\n\n",
         programs_name, pairs, rounds, tables);
  if((chart=(entry **)malloc((pairs)*sizeof(entry *)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate *chart[pairs]\n",
                    programs_name);
    exit(1);
   }
  for(p=1; p<=pairs; p++)
   {
    if((chart[p-1]=(entry *)malloc((rounds)*sizeof(entry)))==NULL)
     {
      fprintf(stderr, "%s: Unable to allocate chart[%d][rounds]\n",
                      programs_name, p);
      exit(1);
     }
   }
  for(p=1; p<=pairs; p++)
   for(r=1; r<=rounds; r++)
    {
     chart[p-1][r-1].table=0;
     chart[p-1][r-1].versus=0;
     chart[p-1][r-1].ns=0;
     chart[p-1][r-1].board_set=0;
     chart[p-1][r-1].stationary=0;
    }
  if(name==NULL)
   {
    name=line;
    sprintf(name, "fair%02d.txt", tables, rounds);
   }
#ifdef M_I8086
  if((fp=fopen(name, "rb"))==NULL)
#else
  if((fp=fopen(name, "r"))==NULL)
#endif
   {
    fprintf(stderr, "%s: Unable to open file '%s' for read\n",
                    programs_name, name);
    exit(1);
   }
  printf("%s: Reading from file '%s'\n\n", programs_name, name);
  for(t=1; t<=tables;)
   {
    if(fgets(buffer, 130, fp)==NULL)
     {
      fprintf(stderr, "%s: Unable to read correctly from file '%s'\n",
              programs_name, name);
      exit(1);
     }
    if(buffer[0]=='#') continue;
    for(i=j=n=0, blanks=1;; j++)
     {
      if(buffer[j]=='\n') buffer[j]='\0';
      if((buffer[j]!=' ')&&(buffer[j]!='\0'))
       {
        if(blanks!=0) {blanks=0; i=j;}
        continue;
       }
      if((buffer[j]=='\0')&&(blanks!=0)) break;
      if((buffer[j]==' ')&&(blanks!=0)) continue;
      if(buffer[j]=='\0') blanks=(-1);
      buffer[j]='\0'; n++;
      if(n==1)
       {
        table=0;
        if(sscanf(&buffer[i], "%d", &table)!=1)
         {
          fprintf(stderr, "%s: bad sscanf for table\n", programs_name);
          exit(1);
         }
       }
      if(n==2)
       {
        p=0;
        if(sscanf(&buffer[i], "%d", &p)!=1)
         {
          fprintf(stderr, "%s: bad sscanf for p\n", programs_name);
          exit(1);
         }
       }
      if(n==3)
       {
        v=0;
        if(sscanf(&buffer[i], "%d", &v)!=1)
         {
          fprintf(stderr, "%s: bad sscanf for v\n", programs_name);
          exit(1);
         }
       }
      if(n==4)
       {
        b=0;
        if(sscanf(&buffer[i], "%d", &b)!=1)
         {
          fprintf(stderr, "%s: bad sscanf for b\n", programs_name);
          exit(1);
         }
       }
      i=j+1;
      if(blanks<0) break;
      blanks=1; continue;
     }
    /*
    printf("t=%02d table=%02d p=%02d v=%02d %b=%02d\n", t, table, p, v, b);
    */
    if((p<1)||(p>pairs))
     {
      fprintf(stderr, "%s: Bad pair in file '%s' t=%d r=%d p=%d\n",
              programs_name, name, t, r, p);
      exit(1);
     }
    if((v<1)||(v>pairs))
     {
      fprintf(stderr, "%s: Bad versus in file '%s' t=%d r=%d p=%d\n",
              programs_name, name, t, r, p);
      exit(1);
     }
    r=1;
    chart[p-1][r-1].versus=v;
    chart[p-1][r-1].table=t;
    chart[p-1][r-1].board_set=b;
    chart[p-1][r-1].ns=1;
    chart[v-1][r-1].versus=p;
    chart[v-1][r-1].table=t;
    chart[v-1][r-1].board_set=b;
    chart[v-1][r-1].ns=0;
    t++;
   }
  while(1)
   {
    for(i=0; i<130; i++) buffer[i]=' ';
    if(fgets(buffer, 130, fp)==NULL) break;
    if(buffer[0]=='#') continue;
    for(i=j=n=0, blanks=1;; j++)
     {
      if(buffer[j]=='\n') buffer[j]='\0';
      if((buffer[j]!=' ')&&(buffer[j]!='\0'))
       {
        if(blanks!=0) {blanks=0; i=j;}
        continue;
       }
      if((buffer[j]=='\0')&&(blanks!=0)) break;
      if((buffer[j]==' ')&&(blanks!=0)) continue;
      if(buffer[j]=='\0') blanks=(-1);
      buffer[j]='\0'; n++;
      if(n==1)
       {
        p=0;
        if(sscanf(&buffer[i], "%d", &p)!=1)
         {
          fprintf(stderr, "%s: bad sscanf for p '%s'\n",
                  programs_name, &buffer[i]);
          exit(1);
         }
        if((p<1)||(p>pairs))
         {
          fprintf(stderr, "%s: Bad pair in file '%s' t=%d r=%d p=%d\n",
                  programs_name, name, t, r, p);
          exit(1);
         }
       }
      if(n==2)
       {
        v=(-1);
        if(((buffer[i]=='E')||(buffer[i]=='e'))
           &&((buffer[i+1]=='W')||(buffer[i+1]=='W'))) v=0;
        if(((buffer[i]=='N')||(buffer[i]=='n'))
           &&((buffer[i+1]=='S')||(buffer[i+1]=='s'))) v=1;
        if(v<0)
         {
          fprintf(stderr, "%s: Bad '%s' in file '%s', expected 'NS' or 'EW'\n",
                  programs_name, &buffer[i], name);
          exit(1);
         }
        for(r=1; r<rounds; r++) chart[p-1][r-1].stationary=1;
       }
      if(n>=3)
       {
        r=0;
        if(sscanf(&buffer[i], "%d", &r)!=1)
         {
          fprintf(stderr, "reading '%s'\n", &buffer[i]);
          fprintf(stderr, "%s: bad sscanf for r '%s'\n", programs_name, &buffer[i]);
          exit(1);
         }
        if(r==0)
         {
          fprintf(stderr, "%s: Bad round in file '%s' '%s'\n",
                  programs_name, name, &buffer[i]);
          exit(1);
         }
        /* mark this pair as inverse table-stationary */
        chart[p-1][r-1].stationary=2;
       }
      i=j+1;
      if(blanks<0) break;
      blanks=1; continue;
     }
   }
  fclose(fp);
  /* Search and mark semi-table-stationary pairs */
  for(p=1; p<=pairs; p++)
   {
    /* count the stationaries */
    for(n=0, r=1; r<=rounds; r++) if(chart[p-1][r-1].stationary!=0) n++;
    /* If it exists make stationary all over */
    if(n>0)
     for(r=1; r<=rounds; r++)
      {
       if(chart[p-1][r-1].stationary==0) chart[p-1][r-1].stationary=1;
      }
   }

  /*
  if(chart[pairs-1][1-1].table!=1) 
   fprintf(stderr, "%s: Warning: Bad table t=%d for highest pair p=%d\n",
           programs_name, chart[pairs-1][1-1].table, pairs);
  */

  /* Permute the non-stationary pairs, round by round, 2 follows 1 etc. */
  for(r=2; r<=rounds; r++)
   {
    for(p=1; p<=pairs; p++)
     {
      /************************************************************************
      * If we are non-stationary                                              *
      ************************************************************************/
      if(chart[p-1][1-1].stationary==0)
       {
        /**********************************************************************
        * search for the next non-stationary pair with a lower number         *
        **********************************************************************/
        for(oldp=(p-1);; oldp--)
         {
          if(oldp<1) oldp=pairs;
          if(chart[oldp-1][1-1].stationary==0) break;
          /* break circle */
          if(oldp==p)
           {
            fprintf(stderr, "%s: Bad oldp search\n", programs_name);
            exit(1);
           }
         }
        if((oldp<1)||(oldp>pairs)) 
         {
          fprintf(stderr, "%s: bad oldp=%2d\n", programs_name, oldp);
         }
        /**********************************************************************
        * So now we have found the table in use the round before              *
        **********************************************************************/
        chart[p-1][r-1].table=chart[oldp-1][r-2].table;
        chart[p-1][r-1].ns=chart[oldp-1][r-2].ns;
        /* Look which pair was played against */
        oldv=chart[oldp-1][r-2].versus;
        if((oldv<1)||(oldv>pairs)) 
         {
          fprintf(stderr, "%s: bad oldv=%2d\n", programs_name, oldp);
         }
        /* Switch back if old versus was a switched stationary pair */
        if(chart[oldv-1][r-2].stationary==2)
         {
          if(chart[p-1][r-1].ns==0) chart[p-1][r-1].ns=1;
          else chart[p-1][r-1].ns=0;
         }
        /* If we were playing versus a non-stationary pair */
        if(chart[oldv-1][r-2].stationary==0)
         {
          /* Since we now have the pair numbers of the previous round, we
            search for the next non-stationary pair with a higher number */
          for(newp=(oldv+1);; newp++)
           {
            if(newp>pairs) newp=1;
            /* break circle */
            if(chart[newp-1][1-1].stationary==0) break;
            if(newp==oldv)
             {
              fprintf(stderr, "%s: Bad newp search\n", programs_name);
              exit(1);
             }
           }
          if((newp<1)||(newp>pairs)) 
           {
            fprintf(stderr, "%s: bad newp=%2d\n", programs_name, oldp);
           }
          chart[p-1][r-1].versus=newp;
         }
        /* if we are playing against a stationary pair */
        else
         {
          chart[p-1][r-1].versus=oldv;
          if(chart[oldv-1][r-1].stationary==2)
           {
            if(chart[p-1][r-1].ns==0) chart[p-1][r-1].ns=1;
            else chart[p-1][r-1].ns=0;
           }
         }
       }
      /************************************************************************
      * If we are stationary                                                  *
      ************************************************************************/
      else
       {
        /* Copy table and direction from the first round */
        chart[p-1][r-1].table=chart[p-1][1-1].table;
        chart[p-1][r-1].ns=chart[p-1][1-1].ns;
        /* Switch if this round we this is a switched stationary pair */
        if(chart[p-1][r-1].stationary==2)
         {
          if(chart[p-1][r-1].ns==0) chart[p-1][r-1].ns=1;
          else chart[p-1][r-1].ns=0;
         }
        oldv=chart[p-1][r-2].versus;
        if((oldv<1)||(oldv>pairs)) 
         {
          fprintf(stderr, "%s: bad oldv=%2d\n", programs_name, oldp);
         }
        /* search for the next non-stationary pair with a higher number */
        for(newp=(oldv+1);; newp++)
         {
          if(newp>pairs) newp=1;
          /* break circle */
          if(chart[newp-1][1-1].stationary==0) break;
          if(newp==oldv)
           {
            fprintf(stderr, "%s: Bad newp search\n", programs_name);
            exit(1);
           }
         }
        chart[p-1][r-1].versus=newp;
       }
     }
   }
  for(r=2; r<=rounds; r++)
   {
    /* The boards move down the TABLES */
    for(t=1; t<=tables; t++)
     {
      /* search for the pair which played at this table the round before */
      for(p=1; p<=pairs; p++) if(chart[p-1][r-2].table==t) break;
      if((p<1)||(p>pairs))
       fprintf(stderr, "%s: bad p=%2d\n", programs_name, p);
      oldb=chart[p-1][r-2].board_set;
      b=oldb+1; if(b>boards) b=1;
      /* if(p==pairs) b=r; */
      /* search for the pair which playes at this table this round */
      for(p=1; p<=pairs; p++) if(chart[p-1][r-1].table==t) break;
      if((p<1)||(p>pairs))
       fprintf(stderr, "%s: bad p=%2d\n", programs_name, p);
      chart[p-1][r-1].board_set=b;
      v=chart[p-1][r-1].versus;
      if((v<1)||(v>pairs))
       fprintf(stderr, "%s: bad v=%2d\n", programs_name, v);
      chart[v-1][r-1].board_set=b;
     }
   }

  ok=1;
  for(r=1; r<=rounds; r++)
   for(p=1; p<=pairs; p++)
    {
     /* we won't play against ourselves */
     if(chart[p-1][r-1].versus==p)
      {
       fprintf(stderr, "%s: playing versus ourself\n",
                        programs_name);
       ok=0;
      }
     if(chart[p-1][r-1].versus==0)
      {
       fprintf(stderr, "%s: missing versus for pair %02d round %02d\n",
                        programs_name, p, r);
       ok=0;
      }
     else
      {
      /* we won't play NS vs. NS or EW vs. EW */
       i=chart[p-1][r-1].versus;
       if((i<1)||(i>pairs))
        {
         fprintf(stderr, "%s: bad versus\n",
                          programs_name);
         ok=0;
        }
       if(((chart[p-1][r-1].ns==0)&&(chart[i-1][r-1].ns==0))
          ||((chart[p-1][r-1].ns!=0)&&(chart[i-1][r-1].ns!=0)))
        {
         if(chart[i-1][r-1].ns!=0)
          fprintf(stderr,
            "%s: pair %02d/%02d, playing NS/NS at table %02d\n",
            programs_name, p, r, chart[p-1][r-1].table);
         else
          fprintf(stderr,
            "%s: pair %02d/%02d, playing EW/EW at table %02d\n",
            programs_name, p, r, chart[p-1][r-1].table);
         ok=0;
        }
       if(chart[p-1][r-1].board_set!=chart[i-1][r-1].board_set)
        {
         fprintf(stderr,
            "%s: pair %02d/%02d, playing different boards at table %02d %2d %2d\n",
            programs_name, p, r, chart[p-1][r-1].table, chart[p-1][r-1].board_set,
            chart[i-1][r-1].board_set);
            ok=0;
        }
       /* we won't play multiple times against the same opponents */
       for(i=1; i<=rounds; i++)
        {
         if(i==r) continue;
         if(chart[p-1][r-1].versus==chart[p-1][i-1].versus)
          {
           fprintf(stderr, "%s: pair %02d/%02d, playing multiple times versus %02d\n",
                            programs_name, p, r, chart[p-1][r-1].versus);
           ok=0;
          }
        }
      }
     if(chart[p-1][r-1].board_set==0)
      {
       fprintf(stderr, "%s: missing board set for pair %02d round %02d\n",
                        programs_name, p, r);
       ok=0;
      }
     else
      {
       /* we won't play a board set again */
       for(i=1; i<=rounds; i++)
        {
         if(i==r) continue;
         if(chart[p-1][r-1].board_set==chart[p-1][i-1].board_set)
          {
           fprintf(stderr, "%s: pair %02d/%02d, playing again board set %02d i=%2d\n",
                            programs_name, p, r, chart[p-1][r-1].board_set, i);
           ok=0;
          }
        }
       /* we won't play a board set several times in a round */
       for(i=1; i<=pairs; i++)
        {
         if(i==p) continue;
         /* at the same table */
         if(chart[p-1][r-1].table==chart[i-1][r-1].table) continue;
         /* same table ??? */
         if(chart[p-1][r-1].table==chart[i-1][r-1].table)
          {
           fprintf(stderr,
                   "%s: pair %02d/%02d, playing board set %02d same round\n",
                   programs_name, p, r, chart[p-1][r-1].board_set);
           ok=0;
          }
        }
      }
     if(chart[p-1][r-1].table==0)
      {
       fprintf(stderr, "%s: missing table for pair %02d round %02d\n",
                        programs_name, p, r);
       ok=0;
      }
     else
      {
       /* we won't sit at several tables parallel */
       for(i=1; i<=pairs; i++)
        {
         if(i==p) continue;
         if(chart[p-1][r-1].table==chart[i-1][r-1].table)
          {
           if(((chart[p-1][r-1].ns==0)&&(chart[i-1][r-1].ns==0))
              ||((chart[p-1][r-1].ns!=0)&&(chart[i-1][r-1].ns!=0)))
            {
             if(chart[i-1][r-1].ns!=0)
              fprintf(stderr,
                      "%s: pair %02d/%02d, playing NS/NS at table %02d\n",
                      programs_name, p, r, chart[p-1][r-1].table);
             else
              fprintf(stderr,
                      "%s: pair %02d/%02d, playing EW/EW at table %02d\n",
                      programs_name, p, r, chart[p-1][r-1].table);
             ok=0;
            }
          }
        }
      }
    }


  badness=0.0;
  /*printf("%s: Done reading from file '%s'\n", programs_name, name);*/
  /****************************************************************************
  * Check for fairness for all pairs. To check for the fairness of a movement * 
  * for a specific pair P, scan through all boards played by P for those ones *
  * played not directly against a specific pair Q.                            *
  ****************************************************************************/
  printf("P."); for(p=1; p<=pairs; p++) printf("    %02d", p); printf("\n");
  /******************
  * Check all pairs *
  ******************/
  for(p=1; p<=pairs; p++)
   {
    printf("%02d ", p);
    /*************************
    * versus all other pairs *
    *************************/
    for(q=1; q<=pairs; q++)
     {
      /*****************************
      * don't compare with ourself *
      *****************************/
      if(p==q) {printf("      "); continue;}
      friend=0; foe=0;
      /******************************************
      * Scan through all boards set played by p *
      ******************************************/
      for(r=1; r<=rounds; r++)
       {
        /********************************************
        * we are not interested in direct opponents *
        ********************************************/
        if(chart[p-1][r-1].versus==q) continue;
        /***********************************
        * Search this board as played by q *
        ***********************************/
        for(i=1; i<=rounds; i++)
         if(chart[p-1][r-1].board_set==chart[q-1][i-1].board_set)
          {
           if(chart[p-1][r-1].ns==0)
            {
             if(chart[q-1][i-1].ns==0) foe++; else friend++;
            }
           else
            {
             if(chart[q-1][i-1].ns==0) friend++; else foe++;
            }
          }
       }
      if((friend!=0)||(foe!=0))
       {
        badness=badness+((double)(friend-foe)*(friend-foe));
        printf(" %02d/%02d", friend, foe);
       }
      else printf(" --/--");
     }
    printf("\n");
   }

  badness=badness/((double)(pairs*(pairs-1)));
  printf("\nFor %02d pairs and %02d rounds the averaged badness is %9.2f\n\n",
         pairs, rounds, badness);
  /************************************************
  * Show how often speficic board sets are played * 
  ************************************************/
  printf("B."); for(b=1; b<=boards; b++) printf(" %2d", b); printf("\n");
  /***********************
  * Check all board sets *
  ***********************/
  printf("  ");
  for(b=1; b<=boards; b++)
   {
    q=0; 
    for(p=1; p<=pairs; p++)
     {
      for(r=1; r<=rounds; r++)
       {
        if(chart[p-1][r-1].board_set==b) q++;
       }
     }
    printf(" %2d", q);
   }
  printf("\n\n");
  name=line;
  sprintf(name, "brip%02d%02d.fr", tables, rounds);
#ifdef M_I8086
  if((fp=fopen(name, "wb"))==NULL)
#else
  if((fp=fopen(name, "w"))==NULL)
#endif
   {
    fprintf(stderr, "%s: Unable to open file '%s' for write\n",
                    programs_name, name);
    exit(1);
   }
  printf("%s: Writing to file '%s'\n\n", programs_name, name);
  boards=0;
  for(t=1; t<=tables; t++)
   {
    for(r=1; r<=rounds; r++)
     {
      for(i=0; i<10; i++) line[i]=0;
      for(p=1; p<=pairs; p++)
       if(chart[p-1][r-1].table==t)
        {
         if((p<1)||(p>pairs))
          {
           fprintf(stderr, "%s: Bad pair for file '%s' t=%d r=%d p=%d\n",
                   programs_name, name, t, r, p);
           exit(1);
          }
         if((chart[p-1][r-1].versus<1)||(chart[p-1][r-1].versus>pairs))
          {
           fprintf(stderr, "%s: Bad versus for file '%s' t=%d r=%d p=%d\n",
                   programs_name, name, t, r, p);
           exit(1);
          }
         if(chart[p-1][r-1].ns==1)
          {
           line[2]=(p)&0XFF;
           line[4]=(chart[p-1][r-1].versus)&0xFF;
           line[1]=(chart[p-1][r-1].board_set)&0xFF;
          }
         else
          {
           line[2]=(chart[p-1][r-1].versus)&0xFF;
           line[4]=(p)&0XFF;
           line[1]=(chart[p-1][r-1].board_set)&0xFF;
          }
         break;
       }
      if(fwrite(line, sizeof(char), 10, fp)!=10)
       {
        fprintf(stderr, "%s: Unable to write correctly to file '%s'\n",
                programs_name, name);
        exit(1);
       }
     }
   }
  fclose(fp);
  exit(0);
 }
