#include <stdio.h>

char *programs_name;

typedef struct entry
 {
  int table, versus, ns, board_set;
 }
entry;

entry **chart;

int main(int iargc, char *argv[], char **envp)
 {
  int b, i, j, p, q, r, t, pairs, rounds, tables, page, pages, row, column,
      friend, foe, boards, files, stationary, director, plus, srounds,
      single;
  double xlen, ylen, badness, h, xs, ys, xtmp;
  char *s, line[132], *name;
  FILE *fp;
  char *direction, *header, *tailer;
  for(programs_name=s=argv[0]; (*s);) if((*s++)=='/') programs_name=s;
  pairs=14; rounds=pairs-1; name=NULL; plus=0; single=0;
  /* 25.4mm=1in=72.27pt => 1pt=(25.4/72.27pt) */
  xs=0.98*(25.4/72.27); ys=0.97*0.93*(25.4/72.27);
  for(i=1; i<iargc; i++)
   {
    if((*argv[i])!='-') name=argv[i];
    if(strncmp(argv[i], "-p", 2)==0)
     {sscanf(argv[i]+2, "%d", &pairs); rounds=pairs-1;}
    if(strncmp(argv[i], "-r", 2)==0) sscanf(argv[i]+2, "%d", &rounds);
    if(strncmp(argv[i], "-s", 2)==0) single=1;
    if(strncmp(argv[i], "+", 1)==0) sscanf(argv[i]+1, "%d", &plus);
   }
  srounds=13;
  if(srounds<rounds) srounds=rounds;
/*****************************************************************************/
  printf("%s: %d pairs with %d rounds\n\n", programs_name, pairs, rounds);
  if((chart=(entry **)malloc((pairs)*sizeof(entry *)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate *chart[pairs]\n",
                    programs_name);
    exit(1);
   }
  for(p=1; p<=pairs; p++)
   {
    if((chart[p-1]=(entry *)malloc((rounds)*sizeof(entry)))==NULL)
     {
      fprintf(stderr, "%s: Unable to allocate chart[%d][rounds]\n",
                      programs_name, p);
      exit(1);
     }
   }
  tables=(pairs+1)/2;
  for(p=1; p<=pairs; p++)
   for(r=1; r<=rounds; r++)
    {
     chart[p-1][r-1].table=0;
     chart[p-1][r-1].versus=0;
     chart[p-1][r-1].ns=0;
     chart[p-1][r-1].board_set=0;
    }
  if(name==NULL)
   {
    name=line;
    sprintf(name, "brip%02d%02d.tue", tables, rounds);
   }
#ifdef M_I8086
  if((fp=fopen(name, "rb"))==NULL)
#else
  if((fp=fopen(name, "r"))==NULL)
#endif
   {
    fprintf(stderr, "%s: Unable to open file '%s' for read\n",
                    programs_name, name);
    exit(1);
   }
/*printf("%s: Reading from file '%s'\n\n", programs_name, name);*/
  boards=0;
  for(t=1; t<=tables; t++)
   {
    for(r=1; r<=rounds; r++)
     {
      if(fread(line, sizeof(char), 10, fp)!=10)
       {
        fprintf(stderr, "%s: Unable to read correctly from file '%s'\n",
                programs_name, name);
        exit(1);
       }
      p=line[2]&0xFF;
      if((p<1)||(p>pairs))
       {
        fprintf(stderr, "%s: Bad pair in file '%s' t=%d r=%d p=%d\n",
                programs_name, name, t, r, p);
        exit(1);
       }
      chart[p-1][r-1].versus=line[4]&0xFF;
      if((chart[p-1][r-1].versus<1)||(chart[p-1][r-1].versus>pairs))
       {
        fprintf(stderr, "%s: Bad versus in file '%s' t=%d r=%d p=%d\n",
                programs_name, name, t, r, p);
        exit(1);
       }
      chart[p-1][r-1].table=t;
      chart[p-1][r-1].board_set=(line[1]&0xFF);
      if(boards<chart[p-1][r-1].board_set)
       boards=chart[p-1][r-1].board_set;
      chart[p-1][r-1].ns=1;
      p=line[4]&0xFF;
      chart[p-1][r-1].versus=line[2]&0xFF;
      chart[p-1][r-1].table=t;
      chart[p-1][r-1].board_set=(line[1]&0xFF);
      if(boards<chart[p-1][r-1].board_set)
       boards=chart[p-1][r-1].board_set;
      chart[p-1][r-1].ns=0;
     }
   }
  fclose(fp);
  badness=0.0;
/*printf("%s: Done reading from file '%s'\n", programs_name, name);*/
  /****************************************************************************
  * Check for fairness for all pairs. To check for the fairness of a movement * 
  * for a specific pair P, scan through all boards played by P for those ones *
  * played not directly against a specific pair Q.                            *
  *                                                                           *
  *                                                                           *
  ****************************************************************************/
  printf("P."); for(p=1; p<=pairs; p++) printf("    %02d", p); printf("\n");
  /******************
  * Check all pairs *
  ******************/
  for(p=1; p<=pairs; p++)
   {
    printf("%02d ", p);
    /*************************
    * versus all other pairs *
    *************************/
    for(q=1; q<=pairs; q++)
     {
      /*****************************
      * don't compare with ourself *
      *****************************/
      if(p==q) {printf("      "); continue;}
      friend=0; foe=0;
      /******************************************
      * Scan through all boards set played by p *
      ******************************************/
      for(r=1; r<=rounds; r++)
       {
        /********************************************
        * we are not interested in direct opponents *
        ********************************************/
        if(chart[p-1][r-1].versus==q) continue;
        /***********************************
        * Search this board as played by q *
        ***********************************/
        for(i=1; i<=rounds; i++)
         if(chart[p-1][r-1].board_set==chart[q-1][i-1].board_set)
          {
           if(chart[p-1][r-1].ns==0)
            {
             if(chart[q-1][i-1].ns==0) foe++; else friend++;
            }
           else
            {
             if(chart[q-1][i-1].ns==0) friend++; else foe++;
            }
          }
       }
      if((friend!=0)||(foe!=0))
       {
        badness=badness+((double)((friend-foe)*(friend-foe)));
        printf(" %02d/%02d", friend, foe);
       }
      else printf(" --/--");
     }
    printf("\n");
   }
  badness=badness/((double)(pairs*(pairs-1)));
  printf("\n\nAveraged badness=%12.4f\n\n", badness);
  /************************************************
  * Show how often speficic board sets are played * 
  ************************************************/
  printf("B."); for(b=1; b<=boards; b++) printf(" %2d", b); printf("\n");
  /***********************
  * Check all board sets *
  ***********************/
  printf("  ");
  for(b=1; b<=boards; b++)
   {
    q=0; 
    for(p=1; p<=pairs; p++)
     {
      for(r=1; r<=rounds; r++)
       {
        if(chart[p-1][r-1].board_set==b) q++;
       }
     }
    printf(" %2d", q);
   }
  printf("\n\n");

  pages=(pairs+8)/9;
  director=0;
  for(p=1; p<=pairs; p++)
   {
    for(stationary=1, r=1; r<=rounds; r++)
     if(chart[p-1][r-1].table!=chart[p-1][1-1].table) stationary=0;
    if(stationary==1)
     {
      if(director==0) director=p;
     }
   }
   printf("Director = %d\n",director);
  for(page=1; page<=pages; page++)
   {
    if(single==0)
     {
      if(plus==0)
       sprintf(name, "bri%02d%02d%c.ps", tables, rounds, (page-1)+'a');
      else
       sprintf(name, "bri%02d%02d%c.ps", tables, rounds, (page-1)+'n');
     }
    else
     {
      sprintf(name, "brip%02d%02d.ps", tables, rounds);
     }
    if(single==2)
     fprintf(fp, "showpage\n");
    else
     {
      if((fp=fopen(name, "w"))==NULL)
       {
        fprintf(stderr, "Unable to write to file '%s'\n", name);
        exit(1);
       }
      if(single==1) single=2;
      fprintf(fp, "%%!\n");
      fprintf(fp, "%%%%Title: bri%02d%02d.ps\n", tables, rounds);
      fprintf(fp, "%%%%Pages: %d\n", pages);
      fprintf(fp, "%%%%BoundingBox: 0 0 5400 7900\n");
      fprintf(fp, "%%%%EndComments\n");
      fprintf(fp, "2.8346 2.8346 scale\n");
      fprintf(fp, "0.2 setlinewidth\n");

      fprintf(fp, "/bigfont{/Helvetica-Bold findfont 12 scalefont setfont}def\n");
      fprintf(fp, "/normbfont{/Helvetica findfont 6 scalefont setfont}def\n");
      fprintf(fp, "/owfont{/Helvetica findfont 4 scalefont setfont}def\n");
      fprintf(fp, "/normfont{/Helvetica-Bold findfont 3 scalefont setfont}def\n");
      fprintf(fp, "/normsfont{/Helvetica-Bold findfont 2 scalefont setfont}def\n");
      fprintf(fp, "/isofont\n");
      fprintf(fp, "{/Helvetica-Bold findfont%%\n"); 
      fprintf(fp, "dup length dict begin\n");
      fprintf(fp, " {1 index /FID ne {def} {pop pop} ifelse} forall\n");
      fprintf(fp, " /Encoding ISOLatin1Encoding def\n");
      fprintf(fp, " currentdict\n");
      fprintf(fp, "end\n");
      fprintf(fp, "/Ti exch definefont pop\n");
      fprintf(fp, "/Ti findfont 5 scalefont setfont\n");
      fprintf(fp, "}def\n");
      fprintf(fp, "/klisofont\n");
      fprintf(fp, "{/Helvetica findfont%%\n"); 
      fprintf(fp, "dup length dict begin\n");
      fprintf(fp, " {1 index /FID ne {def} {pop pop} ifelse} forall\n");
      fprintf(fp, " /Encoding ISOLatin1Encoding def\n");
      fprintf(fp, " currentdict\n");
      fprintf(fp, "end\n");
      fprintf(fp, "/Ti exch definefont pop\n");
      fprintf(fp, "/Ti findfont 3 scalefont setfont\n");
      fprintf(fp, "}def\n");

     }

    for(row=0; row<3; row++)
     for(column=0; column<3; column++)
      {
       p=9*(page-1)+3*row+column+1;
       if(p>pairs) continue;
       for(stationary=1, r=1; r<=rounds; r++)
        if(chart[p-1][r-1].table!=chart[p-1][1-1].table)
         stationary=0;
       fprintf(fp, "gsave\n");
       fprintf(fp, "%.2f %.2f translate\n",
        ((double)(187.0*xs*column+11.0*xs)),
        ((double)(272.0*ys*(2-row)+20.0*ys))); 
       fprintf(fp, "0 0 moveto\n");
       xlen=((double)(184.0*xs)); ylen=((double)(269.0*ys)); 
       fprintf(fp, "%.2f 0 rlineto \n", xlen);
       fprintf(fp, "0 %.2f rlineto \n", ylen);
       fprintf(fp, "-%.2f 0 rlineto\n", xlen);
       fprintf(fp, "0 -%2.f rlineto\n", ylen);
       fprintf(fp, "stroke\n");
       fprintf(fp, "%.2f %.2f moveto\n",((double)(136.0*xs)), ((double)(232.0*ys)));
       fprintf(fp, "0 %.2f rlineto\n", ((double)(37.0*ys)));
       fprintf(fp, "stroke\n");
       fprintf(fp, "isofont\n");
       fprintf(fp, "%.2f %.2f moveto\n",((double)(9.0*xs)), (double)(251.0*ys));
       fprintf(fp, "(Laufkarte) show\n");

       fprintf(fp, "%.2f %.2f moveto\n",((double)(9.0*xs)), (double)(235.0*ys));
       fprintf(fp, "(f\\374r Paar) show\n");
       if (p<10) xtmp = 110.0;
          else xtmp = 90.0;
       fprintf(fp, "%.2f %.2f moveto\n",
        ((double)(xtmp*xs)), ((double)(237.0*ys)));
       fprintf(fp, "bigfont\n");
       fprintf(fp, "(%d) show\n",p);
       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(0.0*xs)), ((double)(232.0*ys)));
       fprintf(fp, "%.2f 0 rlineto \n", xlen);
       fprintf(fp, "stroke\n");
        
       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(0.0*xs)), ((double)(215.0*ys)));
       fprintf(fp, "%.2f 0 rlineto \n", xlen);
       fprintf(fp, "stroke\n");
       if(stationary==1)
        {
         if(p==director) 
	   {
            fprintf(fp, "%.2f %.2f  moveto\n", 
             ((double)(129.0*xs)), ((double)(260.0*ys)));
            fprintf(fp, "klisofont\n");
            fprintf(fp, "(\\247) show \n");
	   } 
         else
	   {
            fprintf(fp, "%.2f %.2f  moveto\n", 
             ((double)(129.0*xs)), ((double)(258.0*ys)));
            fprintf(fp, "normfont\n");
            fprintf(fp, "(S) show \n");
	   }
        } 
       if((director>=1)&&(director<=pairs))
        {
         if(p==chart[director-1][rounds-1].versus)
	   {
            fprintf(fp, "%.2f %.2f  moveto\n", 
             ((double)(128.0*xs)), ((double)(252.0*ys)));
            fprintf(fp, "normbfont\n");
            fprintf(fp, "(*) show \n");
	   }
        }
       if(p==plus)
        {
          fprintf(fp, "%.2f %.2f  moveto\n", 
           ((double)(127.0*xs)), ((double)(258.0*ys)));
          fprintf(fp, "/Helvetica findfont 5 scalefont setfont\n");
          fprintf(fp, "(+) show \n");
        }
       if(plus==0)
	 {
            if (tables<10) xtmp = 155.0; else xtmp = 150.0;
            fprintf(fp, "%.2f %.2f  moveto\n", 
             ((double)(xtmp*xs)), ((double)(253.0*ys)));
            fprintf(fp, "normbfont\n");
            fprintf(fp, "(%d) show \n", tables);
	 }
       else
        {
         if (tables<10) xtmp = 152.0; else xtmp = 147.0;
         fprintf(fp, "%.2f %.2f  moveto\n", 
          ((double)(xtmp*xs)), ((double)(253.0*ys)));
         fprintf(fp, "normbfont\n");
         fprintf(fp, "(%d+) show \n", tables);
        }
       fprintf(fp, "%.2f %.2f  moveto\n", 
        ((double)(138.0*xs)), ((double)(237.0*ys)));
       fprintf(fp, "/Helvetica findfont 5 scalefont setfont\n");
       fprintf(fp, "(Tische) show \n");
       for (i=1; i<srounds; i++)
	 {
          fprintf(fp, "0 %.2f  moveto\n", 
           ((double)((215.0/((double)srounds))*i*ys)));
          fprintf(fp, "%.2f 0 rlineto\n", xlen);
          fprintf(fp, "stroke\n", xlen);
	 }
       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(3.0*xs)), ((double)(220.0*ys)));
       fprintf(fp, "normsfont\n");
       fprintf(fp, "(RUNDE) show\n");

       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(28.0*xs)), ((double)(0.0*ys)));
       fprintf(fp, "0 %.2f rlineto\n", ((double)(232.0*ys)));
       fprintf(fp, "stroke\n", xlen);
       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(32.0*xs)), ((double)(220.0*ys)));
       fprintf(fp, "normsfont\n");
       fprintf(fp, "(AM TISCH ALS) show\n");

       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(76.0*xs)), ((double)(0.0*ys)));
       fprintf(fp, "0 %.2f rlineto\n", ((double)(232.0*ys)));
       fprintf(fp, "stroke\n", xlen);
       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(77.5*xs)), ((double)(220.0*ys)));
       fprintf(fp, "normsfont\n");
       fprintf(fp, "(GEGNER) show\n");

       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(104.0*xs)), ((double)(0.0*ys)));
       fprintf(fp, "0 %.2f rlineto\n", ((double)(232.0*ys)));
       fprintf(fp, "stroke\n", xlen);
       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(110.0*xs)), ((double)(220.0*ys)));
       fprintf(fp, "normsfont\n");
       fprintf(fp, "(2 BOARDS) show\n");

       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(144.0*xs)), ((double)(0.0*ys)));
       fprintf(fp, "0 %.2f rlineto\n", ((double)(232.0*ys)));
       fprintf(fp, "stroke\n", xlen);
       fprintf(fp, "%.2f %.2f  moveto\n", 
         ((double)(150.0*xs)), ((double)(220.0*ys)));
       fprintf(fp, "normsfont\n");
       fprintf(fp, "(3 BOARDS) show\n");
       fprintf(fp, "owfont\n");
       for(r=1; r<=rounds; r++)
        {
         ylen=((double)((215.0/((double)srounds))*((srounds-r)+0.5)*ys))-1.5;
         if(r<10) xtmp=15.0; else xtmp=9.0;
         fprintf(fp, "%.2f %.2f  moveto\n",((double)(xtmp*xs)), ylen);
         fprintf(fp, "(%d) show\n", r);
         if ((chart[p-1][r-1].table)<10) xtmp=41.0; else xtmp=35.0;
         if((chart[p-1][r-1].versus==plus)||(p==plus))
	   {
            if ((tables+1)<10) xtmp=41.0; else xtmp=35.0;
            fprintf(fp, "%.2f %.2f  moveto\n",((double)(xtmp*xs)), ylen);
            fprintf(fp, "(%d) show\n", tables+1);
	   }
         else
	   {
            fprintf(fp, "%.2f %.2f  moveto\n",((double)(xtmp*xs)), ylen);
            fprintf(fp, "(%d) show\n", chart[p-1][r-1].table);
	   }
         if(chart[p-1][r-1].ns==1)
	   {
            fprintf(fp, "%.2f %.2f  moveto\n",((double)(52.0*xs)), ylen);
            fprintf(fp, "(NS) show\n");
	   }
         else
	   {
            fprintf(fp, "%.2f %.2f  moveto\n",((double)(52.0*xs)), ylen);
            fprintf(fp, "(OW) show\n");
	   }

         if ((chart[p-1][r-1].versus)<10) xtmp=90.0; else xtmp=84.0;
         fprintf(fp, "%.2f %.2f  moveto\n",((double)(xtmp*xs)), ylen);
         fprintf(fp, "(%d) show\n", chart[p-1][r-1].versus);


         header=""; if((2*chart[p-1][r-1].board_set-1)<10) header="{\\0}";
         tailer=""; if((2*chart[p-1][r-1].board_set)<10) tailer="{\\0}";

         fprintf(fp, "%.2f %.2f  moveto\n",((double)(124.0*xs)), ylen);
         fprintf(fp, "(-) show\n");

         if ((2*chart[p-1][r-1].board_set-1)<10) xtmp=116.0; else xtmp=110.0;
         fprintf(fp, "%.2f %.2f  moveto\n",((double)(xtmp*xs)), ylen);
         fprintf(fp, "(%d) show\n", 2*chart[p-1][r-1].board_set-1);
         fprintf(fp, "%.2f %.2f  moveto\n",((double)(128.0*xs)), ylen);
         fprintf(fp, "(%d) show\n",2*chart[p-1][r-1].board_set);

         if((3*boards)<=33)
          {
           fprintf(fp, "%.2f %.2f  moveto\n",((double)(164.0*xs)), ylen);
           fprintf(fp, "(-) show\n");
         if ((3*chart[p-1][r-1].board_set-2)<10) xtmp=156.0; else xtmp=150.0;
           fprintf(fp, "%.2f %.2f  moveto\n",((double)(xtmp*xs)), ylen);
           fprintf(fp, "(%d) show\n", 3*chart[p-1][r-1].board_set-2);
           fprintf(fp, "%.2f %.2f  moveto\n",((double)(168.0*xs)), ylen);
           fprintf(fp, "(%d) show\n",3*chart[p-1][r-1].board_set);
          }  
        } 
       fprintf(fp, "grestore\n");
      }
    if(single==0)
     {
      fprintf(fp, "showpage\n");
      fclose(fp);
     }
   }
  if(single!=0)
   {
    fprintf(fp, "showpage\n");
    fclose(fp);
   }
  exit(0);
 }
