#include <stdio.h>

char *programs_name;

typedef struct entry
 {
  int table, versus, ns, board_set;
 }
entry;

entry **chart;

int main(int iargc, char *argv[], char **envp)
 {
  int b, i, j, p, q, r, t, pairs, rounds, tables, page, pages, row, column,
      friend, foe, boards, files, stationary, director, plus, srounds,
      latex2e, use2488, single;
  double xlen, ylen, badness, h, xs, ys;
  char *s, line[132], *name;
  FILE *fp;
  char *direction, *header, *tailer;
  for(programs_name=s=argv[0]; (*s);) if((*s++)=='/') programs_name=s;
  pairs=14; rounds=pairs-1; name=NULL; plus=0; latex2e=0; use2488=0; single=0;
  /* 25.4mm=1in=72.27pt => 1pt=(25.4/72.27pt) */
  xs=0.98*(25.4/72.27); ys=0.93*(25.4/72.27);
  for(i=1; i<iargc; i++)
   {
    if((*argv[i])!='-') name=argv[i];
    if(strncmp(argv[i], "-e", 2)==0) latex2e=1;
    if(strncmp(argv[i], "-p", 2)==0)
     {sscanf(argv[i]+2, "%d", &pairs); rounds=pairs-1;}
    if(strncmp(argv[i], "-r", 2)==0) sscanf(argv[i]+2, "%d", &rounds);
    if(strncmp(argv[i], "-s", 2)==0) single=1;
    if(strncmp(argv[i], "-2488", 5)==0) use2488=1;
    if(strncmp(argv[i], "+", 1)==0) sscanf(argv[i]+1, "%d", &plus);
   }
  srounds=13;
  if(srounds<rounds) srounds=rounds;
/******************************************************************************/
  printf("%s: %d pairs with %d rounds\n\n", programs_name, pairs, rounds);
  if((chart=(entry **)malloc((pairs)*sizeof(entry *)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate *chart[pairs]\n",
                    programs_name);
    exit(1);
   }
  for(p=1; p<=pairs; p++)
   {
    if((chart[p-1]=(entry *)malloc((rounds)*sizeof(entry)))==NULL)
     {
      fprintf(stderr, "%s: Unable to allocate chart[%d][rounds]\n",
                      programs_name, p);
      exit(1);
     }
   }
  tables=(pairs+1)/2;
  for(p=1; p<=pairs; p++)
   for(r=1; r<=rounds; r++)
    {
     chart[p-1][r-1].table=0;
     chart[p-1][r-1].versus=0;
     chart[p-1][r-1].ns=0;
     chart[p-1][r-1].board_set=0;
    }
  if(name==NULL)
   {
    name=line;
    sprintf(name, "brip%02d%02d.tue", tables, rounds);
   }
#ifdef M_I8086
  if((fp=fopen(name, "rb"))==NULL)
#else
  if((fp=fopen(name, "r"))==NULL)
#endif
   {
    fprintf(stderr, "%s: Unable to open file '%s' for read\n",
                    programs_name, name);
    exit(1);
   }
/*printf("%s: Reading from file '%s'\n\n", programs_name, name);*/
  boards=0;
  for(t=1; t<=tables; t++)
   {
    for(r=1; r<=rounds; r++)
     {
      if(fread(line, sizeof(char), 10, fp)!=10)
       {
        fprintf(stderr, "%s: Unable to read correctly from file '%s'\n",
                programs_name, name);
        exit(1);
       }
      p=line[2]&0xFF;
      if((p<1)||(p>pairs))
       {
        fprintf(stderr, "%s: Bad pair in file '%s' t=%d r=%d p=%d\n",
                programs_name, name, t, r, p);
        exit(1);
       }
      chart[p-1][r-1].versus=line[4]&0xFF;
      if((chart[p-1][r-1].versus<1)||(chart[p-1][r-1].versus>pairs))
       {
        fprintf(stderr, "%s: Bad versus in file '%s' t=%d r=%d p=%d\n",
                programs_name, name, t, r, p);
        exit(1);
       }
      chart[p-1][r-1].table=t;
      chart[p-1][r-1].board_set=(line[1]&0xFF);
      if(boards<chart[p-1][r-1].board_set)
       boards=chart[p-1][r-1].board_set;
      chart[p-1][r-1].ns=1;
      p=line[4]&0xFF;
      chart[p-1][r-1].versus=line[2]&0xFF;
      chart[p-1][r-1].table=t;
      chart[p-1][r-1].board_set=(line[1]&0xFF);
      if(boards<chart[p-1][r-1].board_set)
       boards=chart[p-1][r-1].board_set;
      chart[p-1][r-1].ns=0;
     }
   }
  fclose(fp);
  badness=0.0;
/*printf("%s: Done reading from file '%s'\n", programs_name, name);*/
  /****************************************************************************
  * Check for fairness for all pairs. To check for the fairness of a movement * 
  * for a specific pair P, scan through all boards played by P for those ones *
  * played not directly against a specific pair Q.                            *
  *                                                                           *
  *                                                                           *
  ****************************************************************************/
  printf("P."); for(p=1; p<=pairs; p++) printf("    %02d", p); printf("\n");
  /******************
  * Check all pairs *
  ******************/
  for(p=1; p<=pairs; p++)
   {
    printf("%02d ", p);
    /*************************
    * versus all other pairs *
    *************************/
    for(q=1; q<=pairs; q++)
     {
      /*****************************
      * don't compare with ourself *
      *****************************/
      if(p==q) {printf("      "); continue;}
      friend=0; foe=0;
      /******************************************
      * Scan through all boards set played by p *
      ******************************************/
      for(r=1; r<=rounds; r++)
       {
        /********************************************
        * we are not interested in direct opponents *
        ********************************************/
        if(chart[p-1][r-1].versus==q) continue;
        /***********************************
        * Search this board as played by q *
        ***********************************/
        for(i=1; i<=rounds; i++)
         if(chart[p-1][r-1].board_set==chart[q-1][i-1].board_set)
          {
           if(chart[p-1][r-1].ns==0)
            {
             if(chart[q-1][i-1].ns==0) foe++; else friend++;
            }
           else
            {
             if(chart[q-1][i-1].ns==0) friend++; else foe++;
            }
          }
       }
      if((friend!=0)||(foe!=0))
       {
        badness=badness+((double)((friend-foe)*(friend-foe)));
        printf(" %02d/%02d", friend, foe);
       }
      else printf(" --/--");
     }
    printf("\n");
   }
  badness=badness/((double)(pairs*(pairs-1)));
  printf("\n\nFor %02d pairs and %02d rounds the averaged badness is %9.2f\n\n",
         pairs, rounds, badness);
  /************************************************
  * Show how often speficic board sets are played * 
  ************************************************/
  printf("B."); for(b=1; b<=boards; b++) printf(" %2d", b); printf("\n");
  /***********************
  * Check all board sets *
  ***********************/
  printf("  ");
  for(b=1; b<=boards; b++)
   {
    q=0; 
    for(p=1; p<=pairs; p++)
     {
      for(r=1; r<=rounds; r++)
       {
        if(chart[p-1][r-1].board_set==b) q++;
       }
     }
    printf(" %2d", q);
   }
  printf("\n\n");

  pages=(pairs+8)/9;
  director=0;
  for(p=1; p<=pairs; p++)
   {
    for(stationary=1, r=1; r<=rounds; r++)
     if(chart[p-1][r-1].table!=chart[p-1][1-1].table) stationary=0;
    if(stationary==1)
     {
      if(director==0) director=p;
     }
   }
   printf("Director = %d\n",director);
  for(page=1; page<=pages; page++)
   {
    if(single==0)
     {
      if(plus==0)
       sprintf(name, "bri%02d%02d%c.tex", tables, rounds, (page-1)+'a');
      else
       sprintf(name, "bri%02d%02d%c.tex", tables, rounds, (page-1)+'n');
     }
    else
     {
      sprintf(name, "brip%02d%02d.tex", tables, rounds);
     }
    if(single==2)
     fprintf(fp, "\\newpage\n");
    else
     {
      if((fp=fopen(name, "w"))==NULL)
       {
        fprintf(stderr, "Unable to write to file '%s'\n", name);
        exit(1);
       }
      if(single==1) single=2;
      if(latex2e!=0)
       fprintf(fp, "\\documentclass{article}\n");
      else
       fprintf(fp, "\\documentstyle{article}\n");
      fprintf(fp, "\\pagestyle{empty}\n");
      fprintf(fp, "\\headheight         0pt\n");
      fprintf(fp, "\\headsep            0pt\n");
      fprintf(fp, "\\parindent          0em\n");
      fprintf(fp, "\\textwidth        209mm\n");
      fprintf(fp, "\\textheight       295mm\n");
      fprintf(fp, "\\topmargin       -20.4mm\n");
      fprintf(fp, "\\oddsidemargin   -22.4mm\n");
      fprintf(fp, "\\newcommand{\\0}{\\hphantom{0}}\n");
      if(use2488!=0)
       fprintf(fp, "\\newfont{\\riesig}{cmssbx10 scaled 2488}\n");
      else
       fprintf(fp, "\\newfont{\\riesig}{cmssbx10 scaled 3583}\n");
      fprintf(fp, "\\newfont{\\lfett}{cmssbx10 scaled 1200}\n");
      fprintf(fp, "\\newfont{\\fett}{cmssbx10 scaled 1000}\n");
      fprintf(fp, "\\setlength{\\unitlength}{1mm}\n");
      fprintf(fp, "\\begin{document}\n");
     }
    fprintf(fp, "\\begin{picture}(%.2f,%.2f)\n",
     ((double)(xs*567.0)), ((double)(ys*831.0)));
    for(row=0; row<3; row++)
     for(column=0; column<3; column++)
      {
       p=9*(page-1)+3*row+column+1;
       if(p>pairs) continue;
       for(stationary=1, r=1; r<=rounds; r++)
        if(chart[p-1][r-1].table!=chart[p-1][1-1].table)
         stationary=0;
       fprintf(fp, "\\put(%.2f,%.2f){\n",
        ((double)(187.0*xs*column+3.0*xs)),
        ((double)(272.0*ys*(2-row)+20.0*ys))); 
       xlen=((double)(184.0*xs)); ylen=((double)(269.0*ys)); 
       fprintf(fp, "\\makebox(0,0)[bl]{\\begin{picture}(%.2f,%.2f)\n",
        xlen, ylen);
       fprintf(fp, "\\put(0,0){\\line(1,0){%.2f}}\n", xlen);
       fprintf(fp, "\\put(0,0){\\line(0,1){%.2f}}\n", ylen);
       fprintf(fp, "\\put(0,%.2f){\\line(1,0){%.2f}}\n", ylen, xlen);
       fprintf(fp, "\\put(%.2f,0){\\line(0,1){%.2f}}\n", xlen, ylen);
       fprintf(fp, "\\put(%.2f,%.2f){\\line(0,1){%.2f}}\n",
        ((double)(136.0*xs)), ((double)(232.0*ys)),
        ((double)(37.0*ys)));
       fprintf(fp,
        "\\put(%.2f,%.2f){\\makebox(0,0)[l]{{\\LARGE\\sf Laufkarte}}}\n",
        ((double)(9.0*xs)), ((double)(259.0*ys)));
       fprintf(fp,
        "\\put(%.2f,%.2f){\\makebox(0,0)[l]{{\\LARGE\\sf f\\\"ur Paar}}}\n", 
        ((double)(9.0*xs)), ((double)(242.0*ys)));
       fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0)[r]{{\\riesig %d}}}\n",
        ((double)(128.0*xs)), ((double)(251.0*ys)), p);
       fprintf(fp, "\\put(%.2f,%.2f){\\line(1,0){%.2f}}\n",
        ((double)(0.0*xs)), ((double)(232.0*ys)), xlen);
       fprintf(fp, "\\put(%.2f,%.2f){\\line(1,0){%.2f}}\n",
        ((double)(0.0*xs)), ((double)(215.0*ys)), xlen);
       if(stationary==1)
        {
         if(p==director) 
          fprintf(fp,
           "\\put(%.2f,%.2f){\\makebox(0,0)[tr]{{\\large\\sf\\boldmath\\S}}}\n", 
           ((double)(135.0*xs)), ((double)(268.0*ys)));
         else
          fprintf(fp,
           "\\put(%.2f,%.2f){\\makebox(0,0)[tr]{{\\large\\sf S}}}\n", 
           ((double)(135.0*xs)), ((double)(268.0*ys)));
        }
       if((director>=1)&&(director<=pairs))
        {
         if(p==chart[director-1][rounds-1].versus)
          fprintf(fp,
           "\\put(%.2f,%.2f){\\makebox(0,0)[tr]{{\\large\\boldmath$\\star$}}}\n",
            ((double)(135.0*xs)), ((double)(268.0*ys)));
        }
       if(p==plus)
        {
         fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0)[tr]{{\\fett+}}}\n", 
          ((double)(135.0*xs)), ((double)(268.0*ys)));
        }
       /*XXX*/
       if(plus==0)
        fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0){{\\huge\\sf %d}}}\n",
         ((double)(160.0*xs)), ((double)(259.0*ys)), tables);
       else
        {
         fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0){\\huge\\sf %d",
          ((double)(160.0*xs)), ((double)(259.0*ys)), tables);
         fprintf(fp, "\\raisebox{0.35ex}{\\lfett+}");
         fprintf(fp, "\\raisebox{0.20ex}{\\large\\sf 1}}}\n");
        }
       fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0){{\\LARGE\\sf Tische}}}\n", 
        ((double)(160.0*xs)), ((double)(242.0*ys)));
       for (i=1; i<srounds; i++)
        fprintf(fp, "\\put(0,%.2f){\\line(1,0){%.2f}}\n", 
         ((double)((215.0/((double)srounds))*i*ys)), xlen);
       fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0){\\footnotesize\\sf RUN-}}\n",
        ((double)(14.0*xs)), ((double)(228.0*ys)));
       fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0){\\footnotesize\\sf DE}}\n", 
        ((double)(14.0*xs)), ((double)(219.0*ys)));
       fprintf(fp, "\\put(%.2f,%.2f){\\line(0,1){%.2f}}\n", 
        ((double)(28.0*xs)), ((double)(0.0*ys)), ((double)(232.0*ys)));
       fprintf(fp,
        "\\put(%.2f,%.2f){\\makebox(0,0){\\footnotesize\\sf AM TISCH}}\n", 
        ((double)(52.0*xs)), ((double)(228.0*ys)));
       fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0){\\footnotesize\\sf ALS}}\n", 
        ((double)(60.0*xs)), ((double)(219.0*ys)));
       fprintf(fp, "\\put(%.2f,%.2f){\\line(0,1){%.2f}}\n", 
        ((double)(76.0*xs)),((double)(0.0*ys)), ((double)(232.0*ys)));
       fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0){\\footnotesize\\sf GEG-}}\n", 
        ((double)(90.0*xs)), ((double)(228.0*ys)));
       fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0){\\footnotesize\\sf NER}}\n", 
        ((double)(90.0*xs)), ((double)(219.0*ys)));
       fprintf(fp, "\\put(%.2f,%.2f){\\line(0,1){%.2f}}\n", 
        ((double)(104.0*xs)),((double)(0.0*ys)), ((double)(232.0*ys)));
       fprintf(fp,
        "\\put(%.2f,%.2f){\\makebox(0,0){\\footnotesize\\sf BEI~~2}}\n", 
        ((double)(124.0*xs)), ((double)(228.0*ys)));
       fprintf(fp,
        "\\put(%.2f,%.2f){\\makebox(0,0){\\footnotesize\\sf BOARDS}}\n", 
        ((double)(124.0*xs)), ((double)(219.0*ys)));
       fprintf(fp, "\\put(%.2f,%.2f){\\line(0,1){%.2f}}\n", 
        ((double)(144.0*xs)),((double)(0.0*ys)), ((double)(232.0*ys)));
       fprintf(fp,
        "\\put(%.2f,%.2f){\\makebox(0,0){\\footnotesize\\sf BEI~~3}}\n", 
        ((double)(164.0*xs)), ((double)(228.0*ys)));
       fprintf(fp,
        "\\put(%.2f,%.2f){\\makebox(0,0){\\footnotesize\\sf BOARDS}}\n", 
        ((double)(164.0*xs)), ((double)(219.0*ys)));
       for(r=1; r<=rounds; r++)
        {
         ylen=((double)((215.0/((double)srounds))*((srounds-r)+0.5)*ys));
         fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0)[r]{\\Large\\sf %d}}\n",
          ((double)(21*xs)), ylen, r);
         if((chart[p-1][r-1].versus==plus)||(p==plus))
          fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0)[r]{\\Large\\sf %d}}\n",
           ((double)(45*xs)), ylen, tables+1);
         else
          fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0)[r]{\\Large\\sf %d}}\n",
                 ((double)(45*xs)), ylen, chart[p-1][r-1].table);
         if(chart[p-1][r-1].ns==1)
          fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0){\\Large\\sf NS}}\n",
                 ((double)(61*xs)), ylen);
         else
          fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0){\\Large\\sf OW}}\n",
                 ((double)(61*xs)), ylen);
         header=""; if(chart[p-1][r-1].versus<10) header="{\\0}";
         fprintf(fp, "\\put(%.2f,%.2f){\\makebox(0,0) {\\Large\\sf %s%d}}\n",
                 ((double)(90*xs)), ylen, header, chart[p-1][r-1].versus);
         header=""; if((2*chart[p-1][r-1].board_set-1)<10) header="{\\0}";
         tailer=""; if((2*chart[p-1][r-1].board_set)<10) tailer="{\\0}";
         fprintf(fp,
          "\\put(%.2f,%.2f){\\makebox(0,0){\\Large\\sf %s%d--%d%s}}\n",
          ((double)(124*xs)), ylen, header, 2*chart[p-1][r-1].board_set-1,
          2*chart[p-1][r-1].board_set, tailer);
         if((3*boards)<=33)
          {
           header=""; if((3*chart[p-1][r-1].board_set-1)<10) header="{\\0}";
           tailer=""; if((3*chart[p-1][r-1].board_set)<10) tailer="{\\0}";
           fprintf(fp,
            "\\put(%.2f,%.2f){\\makebox(0,0){\\Large\\sf %s%d--%d%s}}\n",
            ((double)(164*xs)), ylen, header, 3*chart[p-1][r-1].board_set-2,
            3*chart[p-1][r-1].board_set, tailer);
          }  
        } 
       fprintf(fp, "\\end{picture}}}\n");
      }
    fprintf(fp, "\\end{picture}\n");
    if(single==0)
     {
      fprintf(fp, "\\end{document}\n");
      fclose(fp);
     }
   }
  if(single!=0)
   {
    fprintf(fp, "\\end{document}\n");
    fclose(fp);
   }
  exit(0);
 }
