#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int	movement;
int	ntables;
int	nrounds;
int	bdsprrd;
int firstmovepair;

int appendix;
int Atable;

int	*share;
int **next;
int **arrowswitch;
int **balance;
int ***guidecard;
int ***traveller;

#define MAXMOVE 3

char movelist[MAXMOVE][3]    = { "HW", "RH", "EM" };

char movestring[MAXMOVE][30] = { "HOWELL", "3/4 HOWELL", "EXPANDED MITCHELL" };

enum {HOWELL, REDHOW, EXMITCH};

char NSEW[2][3] = {"NS", "OW"};


/* Skip whitespace and lines starting with '*' */

void 	skip(FILE* stream)
{
char line[200];
char dummy = fgetc(stream);

while (isspace(dummy))
	dummy = fgetc(stream);

while(dummy == '*')
	{
	fgets(line,200,stream);
	dummy = fgetc(stream);
	}

ungetc(dummy,stream);
}




void	ReadDefs(FILE *stream)
{
char 	move[3], key;
int		i, j, table, round, bdset, pairno, arrcnt;

skip(stream);
move[0] = getc(stream);
move[1] = getc(stream);
move[2] = 0;
for (i=0 ; i<2 ; i++) if (islower(move[i])) move[i]=toupper(move[i]);

for (i=0 ; i<MAXMOVE ; i++)
	if (!strcmp(move,movelist[i]))
		{
		movement = i;
		break;
		}

if (i==MAXMOVE)
	{
	puts("\nUnknown Movement! Exiting ...");
	exit(1);
	}

skip(stream);
fscanf(stream,"%d",&ntables);

switch (movement)
	{
	case HOWELL:	nrounds     = 2*ntables-1;
					break;
	case REDHOW:    skip(stream);
					fscanf(stream,"%d",&nrounds);
					break;
	case EXMITCH:   skip(stream);
					fscanf(stream,"%d",&nrounds);
					break;
	default:		break;
	}

skip(stream);
fscanf(stream,"%d",&bdsprrd);

// allocate arrays (cater for appendix tables)

share	  = calloc(ntables+2, sizeof(int));
next      = calloc(ntables+2, sizeof(int*));
guidecard = calloc(ntables+2, sizeof(int**));

for (table=0 ; table<ntables+2 ; table++)
	{
	next[table]      = calloc(2, sizeof(int));
	guidecard[table] = calloc(nrounds, sizeof(int*));

	for (round=0 ; round<nrounds ; round++)
		guidecard[table][round] = calloc(3, sizeof(int));
	}

traveller = calloc(nrounds, sizeof(int**));

for (bdset=0 ; bdset<nrounds ; bdset++)
	{
	traveller[bdset] = calloc(ntables+2, sizeof(int*));

	for (i=0 ; i<ntables+2 ; i++)
		traveller[bdset][i] = calloc(2, sizeof(int));
	}

arrowswitch = calloc(2*ntables+2, sizeof(int*));

for (i=0 ; i<2*ntables+2 ; i++)
	{
	arrowswitch[i] = calloc(nrounds, sizeof(int));

	for (j=0 ; j<nrounds ; j++)
		arrowswitch[i][j] = 0;
	}


for (table=0 ; table<ntables ; table++)
	for (i=0 ; i<3 ; i++)
		{
		skip(stream);
		fscanf(stream,"%d",guidecard[table][0]+i);
		}

/* reading arrow switches of non-howell movements */
if (movement != HOWELL)
	{
	skip(stream);
	fscanf(stream,"%d",&pairno);

	if (feof(stream))
		return;

	while (pairno)
		{
		pairno--;
		arrcnt = 0;
		skip(stream);

		fscanf(stream,"%d",arrowswitch[pairno]+arrcnt);

		while (arrowswitch[pairno][arrcnt++])
			{
			skip(stream);
			fscanf(stream,"%d",arrowswitch[pairno]+arrcnt);
			};

		skip(stream);
		fscanf(stream,"%d",&pairno);
		};
	}

appendix = 0;

skip(stream);
key = fgetc(stream);

if (key=='A' || key=='a')
	{
	appendix = 1;
	skip(stream);
	fscanf(stream,"%d",&Atable);

	Atable--;

	for (i=0 ; i<2 ; i++)
		{
		arrcnt = 0;
		skip(stream);
		fscanf(stream,"%d",&pairno);
		pairno--;

		fscanf(stream,"%d",arrowswitch[pairno]+arrcnt);

		while (arrowswitch[pairno][arrcnt++])
			{
			skip(stream);
			fscanf(stream,"%d",arrowswitch[pairno]+arrcnt);
			};
		}
	}
}



void	MakeTableGuideCard(int table)
{
int	round, ns, ew, bd, i, switchflag;

ns = guidecard[table][0][0];
ew = guidecard[table][0][1];
bd = guidecard[table][0][2];

if (movement != EXMITCH)
	{
	for (round=1 ; round<nrounds ; round++)
		{
		switchflag = 0;

		if (ns>0)
			ns = (ns%nrounds) + 1;
		else if (arrowswitch[-ns-1][0])
			for (i=0 ; arrowswitch[-ns-1][i]!=0 ; i++)
				if (arrowswitch[-ns-1][i] == round+1)
					{
					switchflag = 1;
					break;
					}

		if (ew>0)
			ew = (ew%nrounds) + 1;
		else if (arrowswitch[-ew-1][0])
			for (i=0 ; arrowswitch[-ew-1][i]!=0 ; i++)
				if (arrowswitch[-ew-1][i] == round+1)
					{
					switchflag = 1;
					break;
					}

		bd = (bd%nrounds) + 1;

		if (switchflag)
			{
			guidecard[table][round][0]=ew;
			guidecard[table][round][1]=ns;
			}
		else
			{
			guidecard[table][round][0]=ns;
			guidecard[table][round][1]=ew;
			}

		guidecard[table][round][2]=bd;
		}
	}
else
	{
	for (round=1 ; round<nrounds ; round++)
		{
		switchflag = 0;

		if (ns>0)
			{
			if (--ns<firstmovepair)
				ns = 2*ntables;
			}
		else if (arrowswitch[-ns-1][0])
			for (i=0 ; arrowswitch[-ns-1][i]!=0 ; i++)
				if (arrowswitch[-ns-1][i] == round+1)
					{
					switchflag = 1;
					break;
					}

		if (ew>0)
			{
			if (--ew<firstmovepair)
				ew = 2*ntables;
			}
		else if (arrowswitch[-ew-1][0])
			for (i=0 ; arrowswitch[-ew-1][i]!=0 ; i++)
				if (arrowswitch[-ew-1][i] == round+1)
					{
					switchflag = 1;
					break;
					}

		bd = (bd%nrounds) + 1;

		if (switchflag)
			{
			guidecard[table][round][0]=ew;
			guidecard[table][round][1]=ns;
			}
		else
			{
			guidecard[table][round][0]=ns;
			guidecard[table][round][1]=ew;
			}

		guidecard[table][round][2]=bd;
		}
	}

}



void	MakeGuideCards(void)
{
int	table,i,pairno;

firstmovepair = 2*ntables+1;

for (table=0 ; table<ntables ; table++)
	for (i=0 ; i<2 ; i++)
		{
		pairno = guidecard[table][0][i];

		if (pairno>0 && pairno<firstmovepair)
			firstmovepair = pairno;
		}


for (table=0 ; table<ntables ; table++)
	MakeTableGuideCard(table);

if (appendix)
	{
	// standard setup for appendix tables

	guidecard[ntables][0][0]   = -2*ntables-1;
	guidecard[ntables][0][1]   = guidecard[Atable][0][1];
	guidecard[ntables][0][2]   = guidecard[Atable][0][2];

	guidecard[ntables+1][0][0] = guidecard[Atable][0][0];
	guidecard[ntables+1][0][1] = -2*ntables-2;
	guidecard[ntables+1][0][2] = guidecard[Atable][0][2];

	for (table=ntables ; table<ntables+2 ; table++)
		MakeTableGuideCard(table);
	}
}



void	MakeNext(void)
{
int	table, i, pairno, tab2, j, end;

for (table=0 ; table<ntables ; table++)
	for (i=0 ; i<2 ; i++)
		{
		pairno = guidecard[table][0][i];

		if (pairno<0)
			next[table][i] = 0;
		else
			{
			end=0;

			for (tab2=0 ; tab2<ntables && !end ; tab2++)
				for (j=0 ; j<2 && !end ; j++)
					if (pairno == guidecard[tab2][1][j])
						{
						next[table][i] = (j==0) ? -(tab2+1) : tab2+1;
						end=1;
						}
			}
		}

if (appendix)
	{
	next[ntables][0]   = 0;
	next[ntables][1]   = next[Atable][1];

	next[ntables+1][0] = next[Atable][0];
	next[ntables+1][1] = 0;
	}
}


void	MakeShare(void)
{
int	tab1, tab2;

for (tab1=0 ; tab1<ntables+1 ; tab1++)
	share[tab1] = 0;

for (tab1=0 ; tab1<ntables-1 ; tab1++)
	for (tab2=tab1+1 ; tab2<ntables ; tab2++)
		if (guidecard[tab1][0][2] == guidecard[tab2][0][2])
			{
			share[tab1] = tab2+1;
			share[tab2] = tab1+1;
			}

if (appendix)
	{
	share[ntables]   = Atable+1;
	share[ntables+1] = Atable+1;
	}
}


void	MakeTravellers(int mode)
{
int	*tcnt = calloc(nrounds, sizeof(int));
int i, table, tab2, round, ns, ew, bd;

for (i=0 ; i<nrounds ; i++)
	tcnt[i] = 0;

for (round=0 ; round<nrounds ; round++)
	for (table=0 ; table<ntables ; table++)
		{
		if (mode && appendix && table==Atable)
			{
			for (tab2=ntables ; tab2<ntables+mode ; tab2++)
				{
				ns = guidecard[tab2][round][0];
				ew = guidecard[tab2][round][1];
				bd = guidecard[tab2][round][2] - 1;

				traveller[bd][tcnt[bd]]  [0] = ns;
				traveller[bd][tcnt[bd]++][1] = ew;
				}
			}
		else
			{
			ns = guidecard[table][round][0];
			ew = guidecard[table][round][1];
			bd = guidecard[table][round][2] - 1;

			traveller[bd][tcnt[bd]]  [0] = ns;
			traveller[bd][tcnt[bd]++][1] = ew;
			}
		}

free(tcnt);
}



void	WriteGuideCards(FILE* stream)
{
int	table, round, ns, ew, bd, nextpos, i;

for (table=0 ; table < (appendix ? ntables+2 : ntables) ; table++)
	{
	if (appendix && table>=ntables)
		fprintf(stream,"(%d+1 TISCHE)\n(%s)\n",ntables,movestring[movement]);
	else
		fprintf(stream,"(%d TISCHE)\n(%s)\n",ntables,movestring[movement]);

	if (share[table])
		{
		if (appendix && table==ntables)
			fprintf(stream,"(Sie spielen im Austausch mit Tisch %dA)\n",share[table]);
		else
			fprintf(stream,"(Sie spielen im Austausch mit Tisch %d)\n",share[table]);
		}
	else
		fprintf(stream,"()\n");

	if (appendix && table>=ntables)
		{
		if (table==ntables)
			{
			if ( ((Atable+1)%10 == 6) || ((Atable+1)%10 == 9))
				fprintf(stream,"(%d.)\n",Atable+1);
			else
				fprintf(stream,"(%d)\n",Atable+1);
			}
		else
			fprintf(stream,"(%dA)\n",Atable+1);
		}
	else
		{
		if ( ((table+1)%10 == 6) || ((table+1)%10 == 9))
			fprintf(stream,"(%d.)\n",table+1);
		else
			fprintf(stream,"(%d)\n",table+1);
		}

	for (round=0 ; round<nrounds ; round++)
		{
		ns = guidecard[table][round][0];
		ew = guidecard[table][round][1];
		bd = guidecard[table][round][2];

		fprintf(stream,"(%d) (%d) (%d\\261%d)\n", abs(ns), abs(ew),
												  bdsprrd*(bd-1)+1,
												  bdsprrd*bd);
		}

	fprintf(stream,"%d\n",nrounds);

	if (   arrowswitch[abs(guidecard[table][0][0])-1][0]
		|| arrowswitch[abs(guidecard[table][0][1])-1][0] )
		{
		nextpos = next[table][0];

		if (!nextpos)
			nextpos = next[table][1];

		if (movement==EXMITCH)
			{
			if (   arrowswitch[abs(guidecard[abs(nextpos)-1][0][0])-1][0]
				|| arrowswitch[abs(guidecard[abs(nextpos)-1][0][1])-1][0] )
				{
				fprintf(stream,"(Paar %d\\261%d ) (\\374) ( Tisch %d)\n",firstmovepair,2*ntables,abs(nextpos));
				fprintf(stream,"(Paar %d\\261%d ) (\\374) ( Tisch %d)\n",firstmovepair,2*ntables,abs(nextpos));
				}
			else
				{
				fprintf(stream,"(Paar %d\\261%d ) (\\374) ( Tisch %d %s)\n",firstmovepair,2*ntables,abs(nextpos),NSEW[nextpos<0 ? 0 : 1]);
				fprintf(stream,"(Paar %d\\261%d ) (\\374) ( Tisch %d %s)\n",firstmovepair,2*ntables,abs(nextpos),NSEW[nextpos<0 ? 0 : 1]);
				}
			}
		else
			{
			if (   arrowswitch[abs(guidecard[abs(nextpos)-1][0][0])-1][0]
				|| arrowswitch[abs(guidecard[abs(nextpos)-1][0][1])-1][0] )
				{
				fprintf(stream,"(Paar 1\\261%d ) (\\374) ( Tisch %d)\n",nrounds,abs(nextpos));
				fprintf(stream,"(Paar 1\\261%d ) (\\374) ( Tisch %d)\n",nrounds,abs(nextpos));
				}
			else
				{
				fprintf(stream,"(Paar 1\\261%d ) (\\374) ( Tisch %d %s)\n",nrounds,abs(nextpos),NSEW[nextpos<0 ? 0 : 1]);
				fprintf(stream,"(Paar 1\\261%d ) (\\374) ( Tisch %d %s)\n",nrounds,abs(nextpos),NSEW[nextpos<0 ? 0 : 1]);
				}
			}
		}
	else
		for (i=0 ; i<2 ; i++)
			{
			nextpos = next[table][i];

			if (nextpos)
				{
				if (   arrowswitch[abs(guidecard[abs(nextpos)-1][0][0])-1][0]
					|| arrowswitch[abs(guidecard[abs(nextpos)-1][0][1])-1][0] )
					fprintf(stream,"() (\\374) ( Tisch %d)\n",abs(nextpos));
				else
					fprintf(stream,"() (\\374) ( Tisch %d %s)\n",abs(nextpos),NSEW[nextpos<0 ? 0 : 1]);
				}
			else
				fprintf(stream,"(Sie bleiben sitzen) () ()\n");
			}

	fprintf(stream,"pairscard\n\n");
	}
}




int main(int argc, char *argv[])
{
char    fname[80];
char	commandline[80];

FILE*	fin;
FILE*	fout;

int c;

/* clrscr(); */

printf("This is MOVEMENT 0.7 (7-95) working on %s.mmm\n",argv[1]);

sprintf(fname,"%s.mmm",argv[1]);
if((fin = fopen(fname,"rt"))==NULL)
 {
  fprintf(stderr, "File '%s' could not be opened for read\n", fname);
  exit(1);
 }
ReadDefs(fin);
fclose(fin);

MakeGuideCards();

MakeNext();

MakeShare();

MakeTravellers(0);

if (appendix)
	{
	MakeTravellers(1);
	MakeTravellers(2);
	}

fclose(fout);


sprintf(fname,"%s.ps",argv[1]);
printf("\nwriting %s\n",fname);
if((fout = fopen(fname,"wt"))==NULL)
 {
  fprintf(stderr, "File '%s' could not be opened for write\n", fname);
  exit(1);
 }
fprintf(fout, "%%!PS-Adobe-2.0\n");
fprintf(fout, "%%%%Creator: Permute\n");
fprintf(fout, "%%%%Title: Guide Cards\n");
fprintf(fout, "%%%%Pages: 1\n");
fprintf(fout, "%%%%DocumentFonts: Helvetica Helvetica-Bold Times-Roman ");
fprintf(fout, "Times-Bold ZapfDingbats ZapfChancery-MediumItalic\n");
fprintf(fout, "%%%%EndComments\n");
fprintf(fout, "/mm { 2.8346 mul } def\n");
fprintf(fout, "/PaperHeight 297 mm def\n");
fprintf(fout, "/PaperWidth  210 mm def\n");
fprintf(fout, "/ThickLineWidth 1.5 def\n");
fprintf(fout, "/ThinLineWidth  0.5 def\n");
fprintf(fout, "/Edge 10 mm def\n");
fprintf(fout, "/setpage {Edge Edge translate} def\n");
fprintf(fout, "/TextHeight PaperHeight Edge 2 mul sub def\n");
fprintf(fout, "/TextWidth  PaperWidth  Edge 2 mul sub def\n");
fprintf(fout, "/TextWhalf  TextWidth 2 div def\n");
fprintf(fout, "/nstr 10 string def\n");
fprintf(fout, "/reencsmalldict 12 dict def\n");
fprintf(fout, "/ReEncodeSmall\n");
fprintf(fout, "    {\n");
fprintf(fout, "    reencsmalldict begin\n");
fprintf(fout, "    /newcodesandnames exch def\n");
fprintf(fout, "    /newfontname exch def\n");
fprintf(fout, "    /basefontname exch def\n");
fprintf(fout, "    /basefontdict basefontname findfont def\n");
fprintf(fout, "    /newfont basefontdict maxlength dict def\n");
fprintf(fout, "    basefontdict\n");
fprintf(fout, "        {\n");
fprintf(fout, "        exch dup /FID ne\n");
fprintf(fout, "            {\n");
fprintf(fout, "            dup /Encoding eq\n");
fprintf(fout, "                {\n");
fprintf(fout, "                exch dup length array copy\n");
fprintf(fout, "                newfont 3 1 roll put\n");
fprintf(fout, "                }\n");
fprintf(fout, "                { exch newfont 3 1 roll put }\n");
fprintf(fout, "                ifelse\n");
fprintf(fout, "             }\n");
fprintf(fout, "             { pop pop }\n");
fprintf(fout, "             ifelse\n");
fprintf(fout, "        }\n");
fprintf(fout, "        forall\n");
fprintf(fout, "    newfont /FontName newfontname put\n");
fprintf(fout, "    newcodesandnames aload pop\n");
fprintf(fout, "    newcodesandnames length 2 idiv\n");
fprintf(fout, "        {\n");
fprintf(fout, "        newfont /Encoding get 3 1 roll put\n");
fprintf(fout, "        }\n");
fprintf(fout, "        repeat\n");
fprintf(fout, "    newfontname newfont definefont pop\n");
fprintf(fout, "    end\n");
fprintf(fout, "    } def\n");
fprintf(fout, "/germvec[\n");
fprintf(fout, "8#201 /udieresis\n");
fprintf(fout, "8#204 /adieresis\n");
fprintf(fout, "8#216 /Adieresis\n");
fprintf(fout, "8#224 /odieresis\n");
fprintf(fout, "8#231 /Odieresis\n");
fprintf(fout, "8#232 /Udieresis\n");
fprintf(fout, "] def\n");
fprintf(fout, "/Helvetica      /German-Helvetica      germvec ReEncodeSmall\n");
fprintf(fout, "/Helvetica-Bold /German-Helvetica-Bold germvec ReEncodeSmall\n");
fprintf(fout, "/Times-Roman    /German-Times          germvec ReEncodeSmall\n");
fprintf(fout, "/Times-Bold     /German-Times-Bold     germvec ReEncodeSmall\n");
fprintf(fout, "/FontHuge  {/German-Times-Bold     findfont 45   mm scalefont} def\n");
fprintf(fout, "/FontBig   {/German-Helvetica-Bold findfont 18   mm scalefont} def\n");
fprintf(fout, "/FontThin  {/German-Helvetica      findfont  4.5 mm scalefont} def\n");
fprintf(fout, "/FontNorm  {/German-Helvetica-Bold findfont  6   mm scalefont} def\n");
fprintf(fout, "/FontText  {/German-Times-Bold     findfont  4.5 mm scalefont} def\n");
fprintf(fout, "/FontSmall {/German-Times-Bold     findfont  5.5 mm scalefont} def\n");
fprintf(fout, "/FontTitle {/German-Helvetica      findfont 10   mm scalefont} def\n");
fprintf(fout, "/FontDing  {/ZapfDingbats          findfont  6   mm scalefont} def\n");
fprintf(fout, "/insidecircletext\n");
fprintf(fout, "    {\n");
fprintf(fout, "    circtextdict begin\n");
fprintf(fout, "        /radius      exch def\n");
fprintf(fout, "        /centerangle exch def\n");
fprintf(fout, "        /ptsize      exch def\n");
fprintf(fout, "        /str         exch def\n");
fprintf(fout, "        /xradius radius ptsize 1.25 div sub def\n");
fprintf(fout, "        gsave\n");
fprintf(fout, "            centerangle str findhalfangle sub rotate\n");
fprintf(fout, "            str\n");
fprintf(fout, "                {\n");
fprintf(fout, "                /charcode exch def\n");
fprintf(fout, "                ( ) dup 0 charcode put insideplacechar\n");
fprintf(fout, "                }\n");
fprintf(fout, "                forall\n");
fprintf(fout, "        grestore\n");
fprintf(fout, "    end\n");
fprintf(fout, "    }  def\n");
fprintf(fout, "/circtextdict 16 dict def\n");
fprintf(fout, "circtextdict begin\n");
fprintf(fout, "    /findhalfangle\n");
fprintf(fout, "        {\n");
fprintf(fout, "        stringwidth pop 2 div\n");
fprintf(fout, "        2 xradius mul pi mul div 360 mul\n");
fprintf(fout, "        } def\n");
fprintf(fout, "    /insideplacechar\n");
fprintf(fout, "        {\n");
fprintf(fout, "        /char exch def\n");
fprintf(fout, "        /halfangle char findhalfangle def\n");
fprintf(fout, "        gsave\n");
fprintf(fout, "            halfangle rotate\n");
fprintf(fout, "            radius 0 translate\n");
fprintf(fout, "            90 rotate\n");
fprintf(fout, "            char stringwidth pop 2 div neg 0 moveto\n");
fprintf(fout, "            char show\n");
fprintf(fout, "        grestore\n");
fprintf(fout, "        halfangle 2 mul rotate\n");
fprintf(fout, "        } def\n");
fprintf(fout, "    /pi 3.1415926 def\n");
fprintf(fout, "end\n");
fprintf(fout, "/stringheight\n");
fprintf(fout, "    {\n");
fprintf(fout, "    gsave\n");
fprintf(fout, "    newpath 0 0 moveto false charpath flattenpath\n");
fprintf(fout, "    pathbbox\n");
fprintf(fout, "    exch pop\n");
fprintf(fout, "    exch sub\n");
fprintf(fout, "    exch pop\n");
fprintf(fout, "    grestore\n");
fprintf(fout, "    } def\n");
fprintf(fout, "/rwidth\n");
fprintf(fout, "    {\n");
fprintf(fout, "    gsave\n");
fprintf(fout, "    newpath 0 0 moveto false charpath flattenpath\n");
fprintf(fout, "    pathbbox\n");
fprintf(fout, "    pop exch pop exch pop\n");
fprintf(fout, "    grestore\n");
fprintf(fout, "    } def\n");
fprintf(fout, "/cwidth\n");
fprintf(fout, "    {\n");
fprintf(fout, "    gsave\n");
fprintf(fout, "    newpath 0 0 moveto false charpath flattenpath\n");
fprintf(fout, "    pathbbox\n");
fprintf(fout, "    pop exch pop add\n");
fprintf(fout, "    grestore\n");
fprintf(fout, "    } def\n");
fprintf(fout, "/cbshow {\n");
fprintf(fout, "        gsave\n");
fprintf(fout, "        translate\n");
fprintf(fout, "    dup\n");
fprintf(fout, "    cwidth neg 2 div 0\n");
fprintf(fout, "    moveto show\n");
fprintf(fout, "        grestore\n");
fprintf(fout, "        } def\n");
fprintf(fout, "/ctshow {\n");
fprintf(fout, "    gsave\n");
fprintf(fout, "    translate\n");
fprintf(fout, "    dup dup\n");
fprintf(fout, "    cwidth neg 2 div exch\n");
fprintf(fout, "    stringheight neg\n");
fprintf(fout, "    moveto show\n");
fprintf(fout, "    grestore\n");
fprintf(fout, "    } def\n");
fprintf(fout, "/ccshow {\n");
fprintf(fout, "        gsave\n");
fprintf(fout, "        translate\n");
fprintf(fout, "    dup dup\n");
fprintf(fout, "    cwidth neg 2 div exch\n");
fprintf(fout, "    stringheight neg 2 div\n");
fprintf(fout, "    moveto show\n");
fprintf(fout, "        grestore\n");
fprintf(fout, "    } def\n");
fprintf(fout, "/lshow {\n");
fprintf(fout, "    gsave\n");
fprintf(fout, "    translate\n");
fprintf(fout, "    dup\n");
fprintf(fout, "    newpath 0 0 moveto false charpath flattenpath\n");
fprintf(fout, "    pathbbox\n");
fprintf(fout, "    pop pop pop neg 0\n");
fprintf(fout, "    moveto show\n");
fprintf(fout, "    grestore\n");
fprintf(fout, "    } def\n");
fprintf(fout, "/rshow {\n");
fprintf(fout, "    gsave\n");
fprintf(fout, "    translate\n");
fprintf(fout, "    dup rwidth neg\n");
fprintf(fout, "    0 moveto show\n");
fprintf(fout, "    grestore\n");
fprintf(fout, "    } def\n");
fprintf(fout, "/ToursHeight  9 mm def\n");
fprintf(fout, "/ToursRadius 24 mm def\n");
fprintf(fout, "/FontMC    {/Bookman-Light findfont 28 mm scalefont} def\n");
fprintf(fout, "/FontTours {/Bookman-Demi  findfont ToursHeight scalefont} def\n");
fprintf(fout, "/tableno\n");
fprintf(fout, "        {\n");
fprintf(fout, "        gsave\n");
fprintf(fout, "        FontHuge setfont\n");
fprintf(fout, "        0 setgray\n");
fprintf(fout, "    dup dup dup\n");
fprintf(fout, "    TextWidth 0 translate\n");
fprintf(fout, "    0 0 rshow\n");
fprintf(fout, "    90 rotate\n");
fprintf(fout, "    TextHeight 0 translate\n");
fprintf(fout, "    0 0 rshow\n");
fprintf(fout, "    90 rotate\n");
fprintf(fout, "    TextWidth 0 translate\n");
fprintf(fout, "    0 0 rshow\n");
fprintf(fout, "    90 rotate\n");
fprintf(fout, "    TextHeight 0 translate\n");
fprintf(fout, "    0 0 rshow\n");
fprintf(fout, "    grestore\n");
fprintf(fout, "        } def\n");
fprintf(fout, "/CenterXOffset 45 mm Edge sub def\n");
fprintf(fout, "/CenterYOffset 45 mm Edge sub def\n");
fprintf(fout, "/CenterWidth  TextWidth  CenterXOffset 2 mul sub def\n");
fprintf(fout, "/CenterHeight 86 mm def\n");
fprintf(fout, "/specialshow\n");
fprintf(fout, "    {\n");
fprintf(fout, "    3 copy\n");
fprintf(fout, "    FontNorm setfont\n");
fprintf(fout, "    stringwidth pop exch\n");
fprintf(fout, "    FontDing setfont\n");
fprintf(fout, "    stringwidth pop add exch\n");
fprintf(fout, "    FontNorm setfont\n");
fprintf(fout, "    stringwidth pop add\n");
fprintf(fout, "    neg 2 div 0 moveto\n");
fprintf(fout, "    3 -1 roll\n");
fprintf(fout, "    FontNorm setfont\n");
fprintf(fout, "    show\n");
fprintf(fout, "    exch\n");
fprintf(fout, "    FontDing setfont\n");
fprintf(fout, "    show\n");
fprintf(fout, "    FontNorm setfont\n");
fprintf(fout, "    show\n");
fprintf(fout, "    } def\n");
fprintf(fout, "/NSEWoffset 12 mm def\n");
fprintf(fout, "/NSEW   {\n");
fprintf(fout, "        gsave\n");
fprintf(fout, "        0 setgray\n");
fprintf(fout, "    TextWhalf 0 translate\n");
fprintf(fout, "    specialshow\n");
fprintf(fout, "    (NORD) FontBig setfont 0 NSEWoffset cbshow\n");
fprintf(fout, "    TextWhalf TextHeight 2 div translate\n");
fprintf(fout, "        90 rotate\n");
fprintf(fout, "    specialshow\n");
fprintf(fout, "    (WEST) FontBig setfont 0 NSEWoffset cbshow\n");
fprintf(fout, "    TextHeight 2 div TextWhalf translate\n");
fprintf(fout, "        90 rotate\n");
fprintf(fout, "    specialshow\n");
fprintf(fout, "    (S\\232D) FontBig setfont 0 NSEWoffset cbshow\n");
fprintf(fout, "    TextWhalf TextHeight 2 div translate\n");
fprintf(fout, "        90 rotate\n");
fprintf(fout, "    specialshow\n");
fprintf(fout, "    (OST) FontBig setfont 0 NSEWoffset cbshow\n");
fprintf(fout, "        grestore\n");
fprintf(fout, "        gsave\n");
fprintf(fout, "        } def\n");
fprintf(fout, "/TopXOffset 45 mm Edge sub def\n");
fprintf(fout, "/TopYOffset 45 mm Edge sub def\n");
fprintf(fout, "/TopHeight  32 mm def\n");
fprintf(fout, "/TopTextYOffset 6 mm def\n");
fprintf(fout, "/title  {\n");
fprintf(fout, "    gsave\n");
fprintf(fout, "    0 setgray\n");
fprintf(fout, "    TopXOffset TextHeight TopYOffset sub translate\n");
fprintf(fout, "    ThickLineWidth setlinewidth\n");
fprintf(fout, "    newpath\n");
fprintf(fout, "    0 0 moveto\n");
fprintf(fout, "    0 TopHeight neg rlineto\n");
fprintf(fout, "    TextWidth TopXOffset 2 mul sub 0 rlineto\n");
fprintf(fout, "    0 TopHeight rlineto\n");
fprintf(fout, "    closepath\n");
fprintf(fout, "    stroke\n");
fprintf(fout, "    grestore\n");
fprintf(fout, "        gsave\n");
fprintf(fout, "    0 setgray\n");
fprintf(fout, "    FontText  setfont\n");
fprintf(fout, "    TextWhalf TextHeight TopYOffset sub TopHeight sub TopTextYOffset sub ctshow\n");
fprintf(fout, "    FontTitle setfont\n");
fprintf(fout, "    TextWhalf TextHeight TopYOffset sub TopHeight sub TopTextYOffset add cbshow\n");
fprintf(fout, "    TextWhalf TextHeight TopYOffset sub TopTextYOffset sub ctshow\n");
fprintf(fout, "    grestore\n");
fprintf(fout, "        } def\n");
fprintf(fout, "/cardcenter\n");
fprintf(fout, "        {\n");
fprintf(fout, "        gsave\n");
fprintf(fout, "    0.95 setgray\n");
fprintf(fout, "    boxheight boxheight CenterHeight\n");
fprintf(fout, "        {\n");
fprintf(fout, "        boxcnt 2 mod 1 eq\n");
fprintf(fout, "            {\n");
fprintf(fout, "            newpath\n");
fprintf(fout, "            0 exch moveto\n");
fprintf(fout, "            0 boxheight neg rlineto\n");
fprintf(fout, "            CenterWidth 0 rlineto\n");
fprintf(fout, "            0 boxheight rlineto\n");
fprintf(fout, "            closepath\n");
fprintf(fout, "            fill\n");
fprintf(fout, "            }\n");
fprintf(fout, "            { pop }\n");
fprintf(fout, "            ifelse\n");
fprintf(fout, "        /boxcnt boxcnt 1 add def\n");
fprintf(fout, "        } for\n");
fprintf(fout, "    0 setgray\n");
fprintf(fout, "    ThickLineWidth setlinewidth\n");
fprintf(fout, "    newpath\n");
fprintf(fout, "    0 CenterHeight boxheight sub moveto\n");
fprintf(fout, "    CenterWidth 0  rlineto\n");
fprintf(fout, "    boxwidth 0 moveto\n");
fprintf(fout, "    0 CenterHeight rlineto\n");
fprintf(fout, "    CenterWidth boxwidth sub 0 moveto\n");
fprintf(fout, "    0 CenterHeight rlineto\n");
fprintf(fout, "    0 0 moveto\n");
fprintf(fout, "    0 CenterHeight rlineto\n");
fprintf(fout, "    CenterWidth 0  rlineto\n");
fprintf(fout, "    0 CenterHeight neg rlineto\n");
fprintf(fout, "    closepath\n");
fprintf(fout, "    stroke\n");
fprintf(fout, "    ThinLineWidth setlinewidth\n");
fprintf(fout, "        newpath\n");
fprintf(fout, "    0 boxheight CenterHeight {0 exch moveto CenterWidth 0 rlineto} for\n");
fprintf(fout, "    0 boxwidth  CenterWidth   {0 moveto 0 CenterHeight rlineto} for\n");
fprintf(fout, "        stroke\n");
fprintf(fout, "        grestore\n");
fprintf(fout, "        } def\n");
fprintf(fout, "/STextTop  45 mm CenterYOffset add CenterHeight add def\n");
fprintf(fout, "/STextLSkip 5 mm def\n");
fprintf(fout, "/standardtext\n");
fprintf(fout, "    {\n");
fprintf(fout, "    gsave\n");
fprintf(fout, "    0 setgray\n");
fprintf(fout, "    FontNorm setfont\n");
fprintf(fout, "    (Anweisung:)\n");
fprintf(fout, "    TextWhalf STextTop cbshow\n");
fprintf(fout, "    FontThin setfont\n");
fprintf(fout, "    (Alle Paare erhalten ihre Nummer in der)\n");
fprintf(fout, "    TextWhalf STextTop STextLSkip sub cbshow\n");
fprintf(fout, "    (ersten Runde und wechseln nach den)\n");
fprintf(fout, "    TextWhalf STextTop STextLSkip 2 mul sub cbshow\n");
fprintf(fout, "    (Angaben auf den Tischlaufkarten !)\n");
fprintf(fout, "    TextWhalf STextTop STextLSkip 3 mul sub cbshow\n");
fprintf(fout, "    FontNorm setfont\n");
fprintf(fout, "    (\\232berpr\\201fen Sie Boards und)\n");
fprintf(fout, "    TextWhalf STextTop STextLSkip 5 mul sub cbshow\n");
fprintf(fout, "    (Paarnummer in jeder Runde !)\n");
fprintf(fout, "    TextWhalf STextTop STextLSkip 6 mul sub cbshow\n");
fprintf(fout, "    FontText setfont\n");
fprintf(fout, "    (Bringen Sie die Boards zum Ablegetisch)\n");
fprintf(fout, "    TextWhalf CenterYOffset STextLSkip 2 mul sub cbshow\n");
fprintf(fout, "    grestore\n");
fprintf(fout, "    } def\n");
fprintf(fout, "/pairscard\n");
fprintf(fout, "    {\n");
fprintf(fout, "    setpage\n");
fprintf(fout, "    6 3 roll 6 copy NSEW\n");
fprintf(fout, "    gsave\n");
fprintf(fout, "    CenterXOffset CenterYOffset translate\n");
fprintf(fout, "    0 setgray\n");
fprintf(fout, "    FontSmall setfont\n");
fprintf(fout, "    dup\n");
fprintf(fout, "    2 mod /boxcnt exch def\n");
fprintf(fout, "    dup\n");
fprintf(fout, "    1 add CenterHeight exch div /boxheight exch def\n");
fprintf(fout, "    CenterWidth 4 div /boxwidth exch def\n");
fprintf(fout, "    cardcenter\n");
fprintf(fout, "    dup 0.5 add /boxoff exch def\n");
fprintf(fout, "    -1 1\n");
fprintf(fout, "        {\n");
fprintf(fout, "%%        dup nstr cvs exch neg boxoff add boxheight mul /yval exch def\n");
fprintf(fout, "         dup 10 mul nstr cvs dup dup length 1 sub 46 put exch neg boxoff\n");
fprintf(fout, "         add boxheight mul /yval exch def\n");
fprintf(fout, "         boxwidth 2 div       yval ccshow\n");
fprintf(fout, "         3 -1 roll\n");
fprintf(fout, "         boxwidth 3 mul 2 div yval ccshow\n");
fprintf(fout, "         exch\n");
fprintf(fout, "         boxwidth 5 mul 2 div yval ccshow\n");
fprintf(fout, "         boxwidth 7 mul 2 div yval ccshow\n");
fprintf(fout, "        } for\n");
fprintf(fout, "    CenterHeight boxheight 2 div sub /yval exch def\n");
fprintf(fout, "    (Runde)  boxwidth       2 div yval ccshow\n");
fprintf(fout, "        (N\\261S) boxwidth 3 mul 2 div yval ccshow\n");
fprintf(fout, "        (O\\261W) boxwidth 5 mul 2 div yval ccshow\n");
fprintf(fout, "        (Boards) boxwidth 7 mul 2 div yval ccshow\n");
fprintf(fout, "        grestore\n");
fprintf(fout, "    tableno\n");
fprintf(fout, "    standardtext\n");
fprintf(fout, "    title\n");
fprintf(fout, "        showpage\n");
fprintf(fout, "        } def\n");
WriteGuideCards(fout);
fclose(fout);

return 0;
}
