#include <stdio.h>

#ifdef M_I8086
#define FOR_DOS
#endif

#define MAXP 16

char *programs_name;

typedef struct entry
 {
  int table, versus, ns, board_set, stationary;
 }
entry;

entry **chart;

int main(int iargc, char *argv[], char **envp)
 {
  int b, i, j, k, l, p, q, r, t, h, pairs, rounds, tables, page, pages,
      row, column, r1, r2, r3, friend, foe, boards, files, ok, n,
      best_r1, best_r2, realr, realb, realt, realp, director, stationary,
      debug, nice, might_be_unshuffled, non_shufflers, skip, mmm,
      played[3], all_shuffled[3],
      minr1[MAXP], minr2[MAXP];
  int *unique, *remap_pairs, *original_pairs, *remap_boards, *original_boards,
      *remap_tables, *original_tables, *remap_rounds, *original_rounds;
  double badness;
  char *s, line[132], *name;
  FILE *fp;
  char *direction, *header, *tailer;
  for(programs_name=s=argv[0]; (*s);) if((*s++)=='/') programs_name=s;
  pairs=14; rounds=pairs-1; boards=0; name=NULL; debug=0; nice=0;
  for(i=1; i<iargc; i++)
   {
    if((*argv[i])!='-') name=argv[i];
    if(strncmp(argv[i], "-p", 2)==0)
     {sscanf(argv[i]+2, "%d", &pairs); rounds=pairs-1;}
    if(strncmp(argv[i], "-r", 2)==0) sscanf(argv[i]+2, "%d", &rounds);
    if(strncmp(argv[i], "-d", 2)==0) debug=1;
    if(strncmp(argv[i], "-n", 2)==0) nice=1;
    if(strncmp(argv[i], "-mmm", 4)==0) mmm=1;
   }
  printf("%s: %d pairs with %d rounds\n\n", programs_name, pairs, rounds);
  if((chart=(entry **)malloc((pairs)*sizeof(entry *)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate *chart[pairs]\n",
                    programs_name);
    exit(1);
   }
  for(p=1; p<=pairs; p++)
   {
    if((chart[p-1]=(entry *)malloc((rounds)*sizeof(entry)))==NULL)
     {
      fprintf(stderr, "%s: Unable to allocate chart[%d][rounds]\n",
                      programs_name, p);
      exit(1);
     }
   }
  tables=(pairs+1)/2;
  for(p=1; p<=pairs; p++)
   for(r=1; r<=rounds; r++)
    {
     chart[p-1][r-1].table=0;
     chart[p-1][r-1].versus=0;
     chart[p-1][r-1].ns=0;
     chart[p-1][r-1].board_set=0;
     chart[p-1][r-1].stationary=0;
    }
  if(name==NULL)
   {
    name=line;
    sprintf(name, "brip%02d%02d.fr", tables, rounds);
   }
#ifdef FOR_DOS
  if((fp=fopen(name, "rb"))==NULL)
#else
  if((fp=fopen(name, "r"))==NULL)
#endif
   {
    fprintf(stderr, "%s: Unable to open file '%s' for read\n",
                    programs_name, name);
    exit(1);
   }
  printf("%s: Reading from file '%s'\n\n", programs_name, name);
  boards=0;
  for(t=1; t<=tables; t++)
   {
    for(r=1; r<=rounds; r++)
     {
      if(fread(line, sizeof(char), 10, fp)!=10)
       {
        fprintf(stderr, "%s: Unable to read correctly from file '%s'\n",
                programs_name, name);
        exit(1);
       }
      p=line[2]&0xFF;
      if((p<1)||(p>pairs))
       {
        fprintf(stderr, "%s: Bad pair in file '%s' t=%d r=%d p=%d\n",
                programs_name, name, t, r, p);
        exit(1);
       }
      chart[p-1][r-1].versus=line[4]&0xFF;
      if((chart[p-1][r-1].versus<1)||(chart[p-1][r-1].versus>pairs))
       {
        fprintf(stderr, "%s: Bad versus in file '%s' t=%d r=%d p=%d\n",
                programs_name, name, t, r, p);
        exit(1);
       }
      chart[p-1][r-1].table=t;
      chart[p-1][r-1].board_set=(line[1]&0xFF);
      if(boards<chart[p-1][r-1].board_set)
       boards=chart[p-1][r-1].board_set;
      chart[p-1][r-1].ns=1;
      p=line[4]&0xFF;
      chart[p-1][r-1].versus=line[2]&0xFF;
      chart[p-1][r-1].table=t;
      chart[p-1][r-1].board_set=(line[1]&0xFF);
      if(boards<chart[p-1][r-1].board_set)
       boards=chart[p-1][r-1].board_set;
      chart[p-1][r-1].ns=0;
     }
   }
  fclose(fp);
  badness=0.0;
/*printf("%s: Done reading from file '%s'\n", programs_name, name);*/
  if((unique=(int *)malloc((rounds)*sizeof(int)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate unique\n",
                    programs_name);
    exit(1);
   }
  if((original_rounds=(int *)malloc((rounds)*sizeof(int)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate original_rounds\n",
                    programs_name);
    exit(1);
   }
  for(i=1; i<=rounds; i++) original_rounds[i-1]=i;
  if((remap_rounds=(int *)malloc((rounds)*sizeof(int)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate remap_rounds\n",
                    programs_name);
    exit(1);
   }
  for(i=1; i<=rounds; i++) remap_rounds[i-1]=i;
  if((remap_pairs=(int *)malloc((pairs)*sizeof(int)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate remap_pairs\n",
                    programs_name);
    exit(1);
   }
  for(i=1; i<=pairs; i++) remap_pairs[i-1]=i;
  if((original_pairs=(int *)malloc((pairs)*sizeof(int)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate original_pairs\n",
                    programs_name);
    exit(1);
   }
  for(i=1; i<=pairs; i++) original_pairs[i-1]=i;
  if((remap_boards=(int *)malloc((boards)*sizeof(int)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate remap_boards\n",
                    programs_name);
    exit(1);
   }
  for(i=1; i<=boards; i++) remap_boards[i-1]=i;
  if((original_boards=(int *)malloc((boards)*sizeof(int)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate original_boards\n",
                    programs_name);
    exit(1);
   }
  for(i=1; i<=boards; i++) original_boards[i-1]=i;
  if((original_tables=(int *)malloc((tables)*sizeof(int)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate original_tables\n",
                    programs_name);
    exit(1);
   }
  for(i=1; i<=tables; i++) original_tables[i-1]=i;
  if((remap_tables=(int *)malloc((tables)*sizeof(int)))==NULL)
   {
    fprintf(stderr, "%s: Unable to allocate remap_tables\n",
                    programs_name);
    exit(1);
   }
  for(i=1; i<=tables; i++) remap_tables[i-1]=i;
  /****************************************************************************
  * Check for fairness for all pairs. To check for the fairness of a movement * 
  * for a specific pair P, scan through all boards played by P for those ones *
  * played not directly against a specific pair Q.                            *
  ****************************************************************************/
  printf("P."); for(p=1; p<=pairs; p++) printf("    %02d", p); printf("\n");
  /******************
  * Check all pairs *
  ******************/
  for(p=1; p<=pairs; p++)
   {
    printf("%02d ", p);
    /*************************
    * versus all other pairs *
    *************************/
    for(q=1; q<=pairs; q++)
     {
      /*****************************
      * don't compare with ourself *
      *****************************/
      if(p==q) {printf("      "); continue;}
      friend=0; foe=0;
      /******************************************
      * Scan through all boards set played by p *
      ******************************************/
      for(r=1; r<=rounds; r++)
       {
        /********************************************
        * we are not interested in direct opponents *
        ********************************************/
        if(chart[p-1][r-1].versus==q) continue;
        /***********************************
        * Search this board as played by q *
        ***********************************/
        for(i=1; i<=rounds; i++)
         if(chart[p-1][r-1].board_set==chart[q-1][i-1].board_set)
          {
           if(chart[p-1][r-1].ns==0)
            {
             if(chart[q-1][i-1].ns==0) foe++; else friend++;
            }
           else
            {
             if(chart[q-1][i-1].ns==0) friend++; else foe++;
            }
          }
       }
      if((friend!=0)||(foe!=0))
       {
        badness=badness+((double)((friend-foe)*(friend-foe)));
        printf(" %02d/%02d", friend, foe);
       }
      else printf(" --/--");
     }
    printf("\n");
   }
  badness=badness/((double)(pairs*(pairs-1)));
  printf("\n\nFor %02d pairs and %02d rounds the averaged badness is %9.2f\n\n",
         pairs, rounds, badness);
  /************************************************
  * Show how often speficic board sets are played * 
  ************************************************/
  printf("B."); for(b=1; b<=boards; b++) printf(" %2d", b); printf("\n");
  /***********************
  * Check all board sets *
  ***********************/
  printf("  ");
  for(b=1; b<=boards; b++)
   {
    q=0; 
    for(p=1; p<=pairs; p++)
     {
      for(r=1; r<=rounds; r++)
       {
        if(chart[p-1][r-1].board_set==b) q++;
       }
     }
    printf(" %2d", q);
   }
  printf("\n\n");
  for(p=1; p<=pairs; p++)
   {
    for(i=0, r=1; r<=rounds; r++)
     if(chart[p-1][r-1].table!=chart[p-1][1-1].table) i=1;
    if(i==0)
     {
      /* check and mark for "inverse stationary" */
      for(r=1; r<=rounds; r++)
       {
        if(chart[p-1][r-1].ns==chart[p-1][1-1].ns) 
         chart[p-1][r-1].stationary=1;
        else chart[p-1][r-1].stationary=2;
       }
     }
   }
  director=0;
  for(p=1; p<=pairs; p++)
   {
    for(stationary=1, r=1; r<=rounds; r++)
     if(chart[p-1][r-1].table!=chart[p-1][1-1].table) stationary=0;
    if(stationary==1)
     {
      if(director==0) director=p;
     }
   }
  /**************************************
  * Check which two rounds to use first *
  **************************************/
  for(i=0; i<MAXP; i++)
   {
    minr1[i]=rounds+1; minr2[i]=rounds+1;
   }
  printf("\n");
  /***********************************************
  * Check which round to use as real first round *
  ***********************************************/
  for(r1=1; r1<=rounds; r1++)
   {
    /************************************************
    * Check which round to use as real second round *
    ************************************************/
    for(r2=1; r2<=rounds; r2++)
     {
      if(r1==r2) continue;
      /***************************************************************
      * The potential surplus pair depens on the choice of r1 and r2 *
      ***************************************************************/
      non_shufflers=0;
      if((director>=1)&&(director<=pairs))
       {
        /*************************************************
        * The pair is the last one of the directors opps *
        *************************************************/
        j=r2-r1; if(j<0) j=j+rounds;
        j=(((r1+j*(rounds-1))-1)%rounds)+1;
        if((j>=1)&&(j<=rounds)) non_shufflers=chart[director-1][j-1].versus;
       }
      r3=(r2+(r2-r1))-1;
      if(r3<0) r3=r3+rounds;
      if(r3<0) r3=r3+rounds;
      if(r3>=rounds) r3=r3-rounds;
      if(r3>=rounds) r3=r3-rounds;
      r3=((r3)%rounds)+1;
      if(r3<1) r3=r3+rounds;
      if(r3<1) r3=r3+rounds;
      if(r3>rounds) r3=r3-rounds;
      if(r3>rounds) r3=r3-rounds;
      for(;((r3==r1)||(r3==r2));)
       {
        r3++;
        if(r3<1) r3=r3+rounds;
        if(r3>rounds) r3=r3-rounds;
       }
      /***************************************************************
      * Check if all boards have been played and thus shuffled       *
      * in the first two or three rounds                             *
      ***************************************************************/
      for(n=0; n<4; n++)
       {
        all_shuffled[0]=1; all_shuffled[1]=1; all_shuffled[2]=1; 
        for(b=1; b<=boards; b++)
         {
          played[0]=0; played[1]=0; played[2]=0;
          for(p=1; p<=pairs; p++)
           {
            if(chart[p-1][r1-1].board_set==b)
             {
              might_be_unshuffled=0;
              if((non_shufflers>=1)&&(non_shufflers<=pairs))
               might_be_unshuffled=chart[non_shufflers-1][r1-1].board_set;
              if((b!=might_be_unshuffled)||
                 ((b==might_be_unshuffled)&&((n&1)!=0)))
               {played[0]++; played[1]++; played[2]++;}
             }
            if(chart[p-1][r2-1].board_set==b)
             {
              might_be_unshuffled=0;
              if((non_shufflers>=1)&&(non_shufflers<=pairs))
               might_be_unshuffled=chart[non_shufflers-1][r2-1].board_set;
              if((b!=might_be_unshuffled)||
                 ((b==might_be_unshuffled)&&((n&2)!=0)))
               {played[1]++; played[2]++;}
             }
            if(chart[p-1][r3-1].board_set==b)
             {
              might_be_unshuffled=0;
              if((non_shufflers>=1)&&(non_shufflers<=pairs))
               might_be_unshuffled=chart[non_shufflers-1][r3-1].board_set;
              /*
              if((b!=might_be_unshuffled)||
                 ((b==might_be_unshuffled)&&((n&4)!=0)))
              */
               {played[2]++;}
             }
           }
          if(played[0]==0)
           {
            all_shuffled[0]=0;
            if(played[1]==0)
             {
              all_shuffled[1]=0;
              if(played[2]==0)
               {
                all_shuffled[2]=0;
               }
             }
           }
          if((played[2]==0)&&debug)
           {
            printf("r1=%d, r2=%d, r3=%d, n=%d, b=%d, ", r1, r2, r3, n, b);
            printf("played=(%d,%d,%d) pot. non_shufflers=%d\n",
            played[0], played[1], played[2], non_shufflers);
           }
         }
        for(i=0; i<MAXP; i++)
         {
          ok=1;
          j=(r2-r1)%rounds;
          if(j<(-rounds/2)) j=j+rounds;
          if(j>(rounds/2)) j=j-rounds;
          if(j<0) j=(-j);
          if((i&4)!=0)
           {
            if(((rounds%j)==0)&&(j!=1)) ok=0;
           }
          /**********************************************
          * The two rightmost bits of n indicate if the *
          * waiting pairs have shuffled as they should  *
          **********************************************/
          if((i&8)!=0)
           {
            if((i&3)==0) {if((!(n==3))||(all_shuffled[1]==0)) ok=0;}
            if((i&3)==1) {if((!((n==1)||(n==2)))||(all_shuffled[1]==0)) ok=0;}
            if((i&3)==2) {if((!(n==0))||(all_shuffled[1]==0)) ok=0;}
            if((i&3)==3) {ok=0;}
           }
          else
           {
            if((i&3)==0) {if((!(n==3))||(all_shuffled[2]==0)) ok=0;}
            if((i&3)==1) {if((!((n==1)||(n==2)))||(all_shuffled[2]==0)) ok=0;}
            if((i&3)==2) {if((!(n==0))||(all_shuffled[2]==0)) ok=0;}
            if((i&3)==3) {ok=0;}
           }
          if(ok==1)
           {
            if(minr1[i]>r1)
             {
              minr1[i]=r1;
              minr2[i]=r2;
             }
            if((minr1[i]==r1)&&(minr2[i]>r2))
             {
              minr1[i]=r1;
              minr2[i]=r2;
             }
           }
         }
        if(debug)
         printf("r1=%d, r2=%d, r3=%d, all_shuffled=(%d,%d,%d)\n",
                r1, r2, r3,
                all_shuffled[0],
                all_shuffled[1],
                all_shuffled[2]);
       }
      if(debug) printf("\n");
     }
   }
  best_r1=rounds+1; best_r2=rounds+1;
  for(i=0; i<MAXP; i++)
   {
    if((i&3)==3) continue;
    printf("i=%2d ", i);
    if(!(((minr1[i]>0)&&(minr1[i]<=rounds))
         &&((minr2[i]>0)&&(minr2[i]<=rounds))))
    printf("----- -----"); 
    else printf("r1=%2d r2=%2d", minr1[i], minr2[i]);
    if((i&8)!=0) printf(" two rounds");
    else         printf("           ");
    if((i&4)!=0) printf(" prime");
    else         printf("      ");
    if((i&3)==0) printf(" 1|2 1&2");
    if((i&3)==1) printf(" 1|2    ");
    if((i&3)==2) printf("        ");
    printf("\n");
    if(((minr1[i]>0)&&(minr1[i]<=rounds))
       &&((minr2[i]>0)&&(minr2[i]<=rounds)))
     {
      best_r1=minr1[i]; best_r2=minr2[i];
     }
   }
  if(((best_r1<1)||(best_r1>rounds))
     ||((best_r2<1)||(best_r2>rounds)))
   {
    printf("NO GOOD\nbest_r1=%d best_r2=%d\n", best_r1, best_r2);
    best_r1=1; best_r2=2;
   }
  printf("best: r1=%2d r2=%2d\n", best_r1, best_r2);

  for(i=1; i<=pairs; i++) remap_pairs[i-1]=i;
  for(i=1; i<=pairs; i++) original_pairs[i-1]=i;
  for(i=1; i<=boards; i++) remap_boards[i-1]=i;
  for(i=1; i<=boards; i++) original_boards[i-1]=i;
  for(i=1; i<=rounds; i++) remap_rounds[i-1]=i;
  for(i=1; i<=rounds; i++) original_rounds[i-1]=i;
  for(i=1; i<=tables; i++) remap_tables[i-1]=i;
  for(i=1; i<=tables; i++) original_tables[i-1]=i;
  name=line;
  sprintf(name, "brip%02d%02d.thw", tables, rounds);
#ifdef FOR_DOS
  if((fp=fopen(name, "wb"))==NULL)
#else
  if((fp=fopen(name, "w"))==NULL)
#endif
   {
    fprintf(stderr, "%s: Unable to open file '%s' for read\n",
                    programs_name, name);
    exit(1);
   }
  for(i=1; i<=rounds; i++) unique[i-1]=0;
  for(r=best_r1, realr=1; realr<=rounds; realr++)
   {
    original_rounds[realr-1]=r;
    remap_rounds[r-1]=realr;
    if(nice)
     {
      if((director>=1)&&(director<=pairs))
       {
        if((chart[director-1][r-1].versus>=1)
           &&(chart[director-1][r-1].versus<=pairs))
         {
          remap_pairs[(chart[director-1][r-1].versus)-1]=realr;
          original_pairs[realr-1]=chart[director-1][r-1].versus;
          remap_boards[(chart[director-1][r-1].board_set)-1]=realr;
          original_boards[realr-1]=chart[director-1][r-1].board_set;
         }
       }
     }
    unique[r-1]=1;
    if(realr>=rounds) break;
    r=r+(best_r2-best_r1);
    r=((r-1)%rounds+1);
    if(r<1) r=r+rounds;
    if(r>rounds) r=r-rounds;
    for(i=(-2); unique[r-1]==1; i++)
     {
      if(i>rounds)
       {
        printf("Bad break\n");
        break;
       }
      r++;
      if(r<1) r=r+rounds;
      if(r>rounds) r=r-rounds;
      if(unique[r-1]==0) break;
     }
   }
  /* Check all remaps */
  for(r=1; r<=rounds; r++)
   {
    for(i=0, j=1; j<=rounds; j++)
     {
      if(remap_rounds[j-1]==r)
       {
        if(i==0) i=remap_rounds[r-1];
        else break;
       }
     }
    if((i==0)||(j<=rounds))
     {
      printf("Bad remap_rounds, using default 1:1\n");
      for(i=1; i<=rounds; i++) remap_rounds[i-1]=i;
      for(i=1; i<=rounds; i++) original_rounds[i-1]=i;
      break;
     }
   }
  for(r=1; r<=rounds; r++)
   {
    for(i=0, j=1; j<=rounds; j++)
     {
      if(original_rounds[j-1]==r)
       {
        if(i==0) i=original_rounds[r-1];
        else break;
       }
     }
    if((i==0)||(j<=rounds))
     {
      printf("Bad original_rounds, using default 1:1\n");
      for(i=1; i<=rounds; i++) remap_rounds[i-1]=i;
      for(i=1; i<=rounds; i++) original_rounds[i-1]=i;
      break;
     }
   }
  for(p=1; p<=pairs; p++)
   {
    for(i=0, j=1; j<=pairs; j++)
     {
      if(remap_pairs[j-1]==p)
       {
        if(i==0) i=remap_pairs[p-1];
        else break;
       }
     }
    if((i==0)||(j<=pairs))
     {
      printf("Bad remap_pairs, using default 1:1\n");
      for(i=1; i<=pairs; i++) remap_pairs[i-1]=i;
      for(i=1; i<=pairs; i++) original_pairs[i-1]=i;
      break;
     }
   }
  for(p=1; p<=pairs; p++)
   {
    for(i=0, j=1; j<=pairs; j++)
     {
      if(original_pairs[j-1]==p)
       {
        if(i==0) i=original_pairs[p-1];
        else break;
       }
     }
    if((i==0)||(j<=pairs))
     {
      printf("Bad original_pairs, using default 1:1\n");
      for(i=1; i<=pairs; i++) remap_pairs[i-1]=i;
      for(i=1; i<=pairs; i++) original_pairs[i-1]=i;
      break;
     }
   }
  for(b=1; b<=boards; b++)
   {
    for(i=0, j=1; j<=boards; j++)
     {
      if(remap_boards[j-1]==b)
       {
        if(i==0) i=remap_boards[b-1];
        else break;
       }
     }
    if((i==0)||(j<=boards))
     {
      printf("Bad remap_boards, using default 1:1\n");
      for(i=1; i<=boards; i++) remap_boards[i-1]=i;
      for(i=1; i<=boards; i++) original_boards[i-1]=i;
      break;
     }
   }
  for(b=1; b<=boards; b++)
   {
    for(i=0, j=1; j<=boards; j++)
     {
      if(original_boards[j-1]==b)
       {
        if(i==0) i=original_boards[b-1];
        else break;
       }
     }
    if((i==0)||(j<=boards))
     {
      printf("Bad original_boards, using default 1:1\n");
      for(i=1; i<=boards; i++) remap_boards[i-1]=i;
      for(i=1; i<=boards; i++) original_boards[i-1]=i;
      break;
     }
   }
  if(nice&&((director>=1)&&(director<=pairs)))
   {
    for(t=1; t<=tables; t++) remap_tables[t-1]=0;
    for(t=1; t<=tables; t++) original_tables[t-1]=0;
    realt=1;
    for(realr=1; realr<=1; realr++)
     {
      r=original_rounds[realr-1];
      if((r>=1)&&(r<=rounds))
       {
        t=chart[director-1][r-1].table;
        if(realr==1) {remap_tables[t-1]=realt; original_tables[realt-1]=t;}
        b=chart[director-1][r-1].board_set;
        if((b>=1)&&(b<=rounds))
         {
          realb=remap_boards[b-1];
          if((realb>=1)&&(realb<=boards))
           {
            skip=0;
            for(n=1; n<boards; n++)
             {
              i=realb+n; if(i>boards) i=i-boards;
              if((i>=1)&&(i<=boards))
               {
                j=original_boards[i-1];
                if((j>=1)&&(j<=boards))
                 {
                  for(p=1; p<=pairs; p++)
                   if(chart[p-1][r-1].board_set==j) break;
                  if(p>pairs) skip++;
                  else
                   {
                    k=chart[p-1][r-1].table;
                    if((k>=1)&&(k<=tables))
                     {
                      realt++;
                      if(remap_tables[k-1]==0)
                       {
                        remap_tables[k-1]=realt;
                        original_tables[realt-1]=k;
                       }
                     }
                   }
                 }
               }
             }
           }
         }
       }
     }
    printf("\nnew remap_tables:");
    for(t=1; t<=tables; t++) printf(" %d", remap_tables[t-1]);
    printf("\n");
   }
  for(t=1; t<=tables; t++)
   {
    for(i=0, j=1; j<=tables; j++)
     {
      if(remap_tables[j-1]==t)
       {
        if(i==0) i=remap_tables[t-1];
        else break;
       }
     }
    if((i==0)||(j<=tables))
     {
      printf("Bad remap_tables, using default 1:1\n");
      for(i=1; i<=tables; i++) remap_tables[i-1]=i;
      for(i=1; i<=tables; i++) original_tables[i-1]=i;
      break;
     }
   }
  for(t=1; t<=tables; t++)
   {
    for(i=0, j=1; j<=tables; j++)
     {
      if(original_tables[j-1]==t)
       {
        if(i==0) i=original_tables[t-1];
        else break;
       }
     }
    if((i==0)||(j<=tables))
     {
      printf("Bad original_tables, using default 1:1\n");
      for(i=1; i<=tables; i++) remap_tables[i-1]=i;
      for(i=1; i<=tables; i++) original_tables[i-1]=i;
      break;
     }
   }
  printf("\noriginal_rounds:");
  for(r=1; r<=rounds; r++) printf(" %d", original_rounds[r-1]);
  printf("\nremap_pairs:");
  for(p=1; p<=pairs; p++) printf(" %d", remap_pairs[p-1]);
  printf("\noriginal_pairs:");
  for(p=1; p<=pairs; p++) printf(" %d", original_pairs[p-1]);
  printf("\nremap_boards:");
  for(b=1; b<=boards; b++) printf(" %d", remap_boards[b-1]);
  printf("\noriginal_boards:");
  for(b=1; b<=boards; b++) printf(" %d", original_boards[b-1]);
  printf("\nremap_tables:");
  for(t=1; t<=tables; t++) printf(" %d", remap_tables[t-1]);
  printf("\noriginal_tables:");
  for(t=1; t<=tables; t++) printf(" %d", original_tables[t-1]);
  printf("\n");
  for(realt=1; realt<=tables; realt++)
   {
    t=original_tables[realt-1];
    r=best_r1;
    for(i=1; i<=rounds; i++) unique[i-1]=0;
    for(realr=1; realr<=rounds; realr++)
     {
      for(n=1; n<=pairs; n++)
       {
        for(p=1; p<=pairs; p++)
         {
          if(n!=remap_pairs[p-1]) continue;
          /*XXX*/
          if(chart[p-1][r-1].table==t)
           {
            for(i=0; i<10; i++) line[i]=0;
            line[1]=remap_boards[chart[p-1][r-1].board_set-1];
            if(chart[p-1][r-1].ns)
             {
              line[2]=remap_pairs[p-1];
              if((chart[p-1][r-1].versus>=1)&&(chart[p-1][r-1].versus<=pairs))
               line[4]=remap_pairs[(chart[p-1][r-1].versus)-1];
              else printf("Bad versus %d\n", (chart[p-1][r-1].versus));
             }
            else
             {
              if((chart[p-1][r-1].versus>=1)&&(chart[p-1][r-1].versus<=pairs))
               line[2]=remap_pairs[(chart[p-1][r-1].versus)-1];
              else printf("Bad versus %d\n", (chart[p-1][r-1].versus));
              line[4]=remap_pairs[p-1];
             }
            if(fwrite(line, sizeof(char), 10, fp)!=10)
             {
              fprintf(stderr, "%s: Unable to write correctly to file '%s'\n",
                              programs_name, name);
              exit(1);
             }
            break; /* <== */
           }
         }
        if(p<=pairs) break;
       }
      unique[r-1]=1;
      if(realr>=rounds) break;
      r=r+(best_r2-best_r1);
      r=((r-1)%rounds+1);
      if(r<1) r=r+rounds;
      if(r>rounds) r=r-rounds;
      for(i=(-2); unique[r-1]==1; i++)
       {
        if(i>rounds)
         {
          printf("Bad break\n");
          break;
         }
        r++;
        if(r<1) r=r+rounds;
        if(r>rounds) r=r-rounds;
       if(unique[r-1]==0) break;
       }
     }
   }
  fclose(fp);
  sprintf(name, "brip%02d%02d.txt", tables, rounds);
  if((fp=fopen(name, "w"))==NULL)
   {
    fprintf(stderr, "%s: Unable to open file '%s' for write\n",
                    programs_name, name);
    exit(1);
   }
  printf("%s: Writing to file '%s'\n\n", programs_name, name);
  fprintf(fp, "#\n");
  if(rounds==(pairs-1))
   fprintf(fp, "# Starting positions for a %d tables, %d rounds howell with\n",
           tables, rounds);
  else
   fprintf(fp,
    "# Starting positions for a %d tables, %d rounds reduced howell with\n",
    tables, rounds);
  fprintf(fp, "# tables, n/s-pairs, e/w-pairs and first boardsets.\n");
  fprintf(fp, "#\n");
  n=0;
  for(realt=1; realt<=tables; realt++)
   {
    r=original_rounds[1-1]; 
    for(p=1; p<=pairs; p++)
     if(chart[p-1][r-1].table==original_tables[realt-1]) break;
    if((p>=1)&&(p<=pairs))
     {
      if(chart[p-1][r-1].ns!=0)
       fprintf(fp, "%2d %2d %2d %2d\n", realt,
               remap_pairs[p-1],
               remap_pairs[(chart[p-1][r-1].versus)-1],
               remap_boards[(chart[p-1][r-1].board_set)-1]);
      else
       fprintf(fp, "%2d %2d %2d %2d\n", realt,
               remap_pairs[(chart[p-1][r-1].versus)-1],
               remap_pairs[p-1],
               remap_boards[(chart[p-1][r-1].board_set)-1]);
      if(chart[p-1][r-1].stationary!=0) n++;
      i=chart[p-1][r-1].versus;
      if((i>=1)&&(i<=pairs)) if(chart[i-1][r-1].stationary!=0) n++;
     }
   }
  if(n>0)
   {
    n=0;
    for(realp=1; realp<=pairs; realp++)
     {
      p=original_pairs[realp-1];
      if((p>=1)&&(p<=pairs))
       {
        if(chart[p-1][1-1].stationary==0) continue;
        for(realr=1; realr<=rounds; realr++)
         {
          r=original_rounds[realr-1];
          if((r>=1)&&(r<=rounds))
           {
            if(chart[p-1][r-1].stationary!=chart[p-1][1-1].stationary) break;
           }
         }
        if(realr>rounds) n++;
       }
     }
    if(n!=0)
     {
      fprintf(fp, "#\n");
      fprintf(fp, "# Table-stationary pairs.\n");
      fprintf(fp, "#\n");
      for(realp=1; realp<=pairs; realp++)
       {
        p=original_pairs[realp-1];
        n=0;
        if((p>=1)&&(p<=pairs))
         {
          if(chart[p-1][1-1].stationary==0) continue;
          for(realr=1; realr<=rounds; realr++)
           {
            r=original_rounds[realr-1];
            if((r>=1)&&(r<=rounds))
             {
              if(chart[p-1][r-1].stationary!=chart[p-1][1-1].stationary) break;
             }
           }
          if(realr>rounds) n++;
         }
        if(n!=0)
         {
          r=original_rounds[1-1];
          if((r>=1)&&(r<=rounds))
           {
            i=chart[p-1][r-1].stationary;
            if(i!=0)
             {
              if(chart[p-1][r-1].ns!=0)
               {
                if(i==1) fprintf(fp, "%2d: NS", realp);
                if(i==2) fprintf(fp, "%2d: EW", realp);
               }
              else
               {
                if(i==1) fprintf(fp, "%2d: EW", realp);
                if(i==2) fprintf(fp, "%2d: NS", realp);
               }
             }
           }
          fprintf(fp, "\n");
         }
       }
     }
    n=0;
    for(realp=1; realp<=pairs; realp++)
     {
      p=original_pairs[realp-1];
      if((p>=1)&&(p<=pairs))
       {
        if(chart[p-1][1-1].stationary==0) continue;
        for(realr=1; realr<=rounds; realr++)
         {
          r=original_rounds[realr-1];
          if((r>=1)&&(r<=rounds))
           {
            if(chart[p-1][r-1].stationary!=chart[p-1][1-1].stationary) break;
           }
         }
        if(realr<=rounds) n++;
       }
     }
    if(n!=0)
     {
      fprintf(fp, "#\n");
      fprintf(fp, "# Arrow switches for table-stationary pairs.\n");
      fprintf(fp, "#\n");
      for(realp=1; realp<=pairs; realp++)
       {
        p=original_pairs[realp-1];
        n=0;
        if((p>=1)&&(p<=pairs))
         {
          if(chart[p-1][1-1].stationary==0) continue;
          for(realr=1; realr<=rounds; realr++)
           {
            r=original_rounds[realr-1];
            if((r>=1)&&(r<=rounds))
             {
              if(chart[p-1][r-1].stationary!=chart[p-1][1-1].stationary) break;
             }
           }
          if(realr<=rounds) n++;
         }
        if(n!=0)
         {
          r=original_rounds[1-1];
          if((r>=1)&&(r<=rounds))
           {
            i=chart[p-1][r-1].stationary;
            if(i!=0)
             {
              if(chart[p-1][r-1].ns!=0)
               {
                if(i==1) fprintf(fp, "%2d: EW", realp);
                if(i==2) fprintf(fp, "%2d: NS", realp);
               }
              else
               {
                if(i==1) fprintf(fp, "%2d: NS", realp);
                if(i==2) fprintf(fp, "%2d: EW", realp);
               }
             }
           }
          for(realr=1; realr<=rounds; realr++)
           {
            r=original_rounds[realr-1];
            if(chart[p-1][r-1].stationary==2) fprintf(fp, " %2d", realr);
           }
          fprintf(fp, "\n");
         }
       }
     }
   }
  fclose(fp);
  name=line;
  sprintf(name, "%02d_%02d_th.how", pairs, rounds);
  if((fp=fopen(name, "w"))==NULL)
   {
    fprintf(stderr, "%s: Unable to open file '%s' for write\n",
                    programs_name, name);
    exit(1);
   }
  printf("%s: Writing to file '%s'\n\n", programs_name, name);
  fprintf(fp, "# Generated by program 'permute'\n");
  fprintf(fp, "#\n");
  fprintf(fp, ";\n");
  if(rounds==(pairs-1))
   fprintf(fp, "Pair;1/1-Howell\n");
  else
   fprintf(fp, "Pair;3/4-Howell\n");
  fprintf(fp, "%02d;%02d\n", tables, rounds);
  boards=0;
  for(t=1; t<=tables; t++)
   {
    fprintf(fp, "# Table %02d\n", t);
    for(r=1; r<=rounds; r++)
     {
      for(p=1; p<=pairs; p++)
       if(chart[p-1][r-1].table==t)
        {
         if((p<1)||(p>pairs))
          {
           fprintf(stderr, "%s: Bad pair for file '%s' t=%d r=%d p=%d\n",
                   programs_name, name, t, r, p);
           exit(1);
          }
         if((chart[p-1][r-1].versus<1)||(chart[p-1][r-1].versus>pairs))
          {
           fprintf(stderr, "%s: Bad versus for file '%s' t=%d r=%d p=%d\n",
                   programs_name, name, t, r, p);
           exit(1);
          }
         if(chart[p-1][r-1].ns==1)
          {
           fprintf(fp, "%02d;%02d;%02d\n",
                   p, chart[p-1][r-1].versus, chart[p-1][r-1].board_set);
          }
         else
          {
           fprintf(fp, "%02d;%02d;%02d\n",
                   chart[p-1][r-1].versus, p, chart[p-1][r-1].board_set);
          }
         break;
       }
     }
   }
  fclose(fp);
  if(mmm)
   {
    name=line;
    sprintf(name, "%02d_%02d_th.mmm", tables, rounds);
    if((fp=fopen(name, "w"))==NULL)
     {
      fprintf(stderr, "%s: Unable to open file '%s' for write\n",
                      programs_name, name);
      exit(1);
     }
    if(rounds==(pairs-1))
     {
      mmm=2;
      if((tables==5)&&(rounds==9)) mmm=3;
     }
    else
     {
      mmm=2;
      if((tables==6)&&(rounds==9)) mmm=3;
     }
    printf("%s: Writing to file '%s'\n\n", programs_name, name);
  
    fprintf(fp, "* Howell %d Tische (%d Runden) x %d Boards\n",
                tables, rounds, mmm);
    fprintf(fp, "* Generiert durch 'permute'\n");
    fprintf(fp, "*\n");
    if(rounds==(pairs-1))
     fprintf(fp, "HW %3d %3d\n", tables, mmm);
    else
     fprintf(fp, "RH %3d %3d %3d\n", tables, rounds, mmm);
    fprintf(fp, "* NS  OW  Boardsatz\n");
    for(t=1; t<=tables; t++)
     {
      for(p=1; p<=pairs; p++)
       if(chart[p-1][1-1].table==t)
        {
         if((p<1)||(p>pairs))
          {
           fprintf(stderr, "%s: Bad pair for file '%s' t=%d r=%d p=%d\n",
                   programs_name, name, t, 1, p);
           exit(1);
          }
         if((chart[p-1][1-1].versus<1)||(chart[p-1][1-1].versus>pairs))
          {
           fprintf(stderr, "%s: Bad versus for file '%s' t=%d r=%d p=%d\n",
                   programs_name, name, t, 1, p);
           exit(1);
          }
         i=p;
         if(chart[p-1][1-1].stationary!=0) i=(-i);
         j=chart[p-1][1-1].versus;
         if(chart[j-1][1-1].stationary!=0) j=(-j);
         if(chart[p-1][1-1].ns==1)
          fprintf(fp, " %3d %3d %3d\n", i, j, chart[p-1][1-1].board_set);
         else
          fprintf(fp, " %3d %3d %3d\n", j, i, chart[p-1][1-1].board_set);
         break;
       }
     }
    if(rounds!=(pairs-1))
     {
      for(i=0, p=1; p<=pairs; p++)
       for(r=1; r<=rounds; r++)
        if(chart[p-1][r-1].stationary==2) i++;
      if(i!=0) fprintf(fp, "* Arrowswitches\n");
      for(p=1; p<=pairs; p++)
       {
        for(i=0, r=1; r<=rounds; r++)
         if(chart[p-1][r-1].stationary==2) i++;
        if(i>0)
         {
          fprintf(fp, " %3d", p);
          for(r=1; r<=rounds; r++)
           if(chart[p-1][r-1].stationary==2)
            {
             fprintf(fp, " %3d", r);
            }
          fprintf(fp, " %3d\n", 0);
         }
       }
     }
    fprintf(fp, "0\n");
    fclose(fp);
   }
  exit(0);
 }
